/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.ast.codecompletion.revisited.modules;

import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.python.pydev.ast.codecompletion.revisited.AbstractASTManager;
import org.python.pydev.ast.codecompletion.revisited.AbstractToken;
import org.python.pydev.ast.codecompletion.revisited.ConcreteToken;
import org.python.pydev.ast.codecompletion.revisited.modules.AbstractModule;
import org.python.pydev.ast.codecompletion.revisited.modules.ClassDefTokensExtractor;
import org.python.pydev.ast.codecompletion.revisited.modules.CompiledModule;
import org.python.pydev.ast.codecompletion.revisited.modules.CompiledToken;
import org.python.pydev.ast.codecompletion.revisited.modules.IAbstractJavaClassModule;
import org.python.pydev.ast.codecompletion.revisited.modules.SourceToken;
import org.python.pydev.ast.codecompletion.revisited.visitors.AssignOrTypeAliasDefinition;
import org.python.pydev.ast.codecompletion.revisited.visitors.Definition;
import org.python.pydev.ast.codecompletion.revisited.visitors.FindDefinitionModelVisitor;
import org.python.pydev.ast.codecompletion.revisited.visitors.FindScopeVisitor;
import org.python.pydev.ast.codecompletion.revisited.visitors.GlobalModelVisitor;
import org.python.pydev.ast.codecompletion.revisited.visitors.KeywordParameterDefinition;
import org.python.pydev.ast.codecompletion.revisited.visitors.LocalScope;
import org.python.pydev.ast.codecompletion.revisited.visitors.StopVisitingException;
import org.python.pydev.ast.codecompletion.revisited.visitors.TypeInfoDefinition;
import org.python.pydev.core.ICodeCompletionASTManager;
import org.python.pydev.core.ICompletionCache;
import org.python.pydev.core.ICompletionState;
import org.python.pydev.core.IDefinition;
import org.python.pydev.core.ILocalScope;
import org.python.pydev.core.IModule;
import org.python.pydev.core.IModuleRequestState;
import org.python.pydev.core.IPythonNature;
import org.python.pydev.core.ISourceModule;
import org.python.pydev.core.IToken;
import org.python.pydev.core.ITypeInfo;
import org.python.pydev.core.IterTokenEntry;
import org.python.pydev.core.ModulesKey;
import org.python.pydev.core.ModulesKeyForZip;
import org.python.pydev.core.NoExceptionCloseable;
import org.python.pydev.core.TokensList;
import org.python.pydev.core.TupleN;
import org.python.pydev.core.log.Log;
import org.python.pydev.core.preferences.FileTypesPreferences;
import org.python.pydev.core.structure.CompletionRecursionException;
import org.python.pydev.parser.jython.SimpleNode;
import org.python.pydev.parser.jython.ast.Assign;
import org.python.pydev.parser.jython.ast.Call;
import org.python.pydev.parser.jython.ast.ClassDef;
import org.python.pydev.parser.jython.ast.Expr;
import org.python.pydev.parser.jython.ast.FunctionDef;
import org.python.pydev.parser.jython.ast.ImportFrom;
import org.python.pydev.parser.jython.ast.Module;
import org.python.pydev.parser.jython.ast.Name;
import org.python.pydev.parser.jython.ast.NameTok;
import org.python.pydev.parser.jython.ast.Str;
import org.python.pydev.parser.jython.ast.TypeAlias;
import org.python.pydev.parser.jython.ast.VisitorIF;
import org.python.pydev.parser.jython.ast.exprType;
import org.python.pydev.parser.visitors.NodeUtils;
import org.python.pydev.parser.visitors.TypeInfo;
import org.python.pydev.shared_core.cache.Cache;
import org.python.pydev.shared_core.cache.LRUCache;
import org.python.pydev.shared_core.callbacks.CallbackWithListeners;
import org.python.pydev.shared_core.io.FileUtils;
import org.python.pydev.shared_core.model.ISimpleNode;
import org.python.pydev.shared_core.string.FullRepIterable;
import org.python.pydev.shared_core.string.LineCol;
import org.python.pydev.shared_core.string.StringUtils;
import org.python.pydev.shared_core.structure.FastStack;
import org.python.pydev.shared_core.structure.Tuple;
import org.python.pydev.shared_core.structure.Tuple3;

public class SourceModule
extends AbstractModule
implements ISourceModule {
    private static final IToken[] EMPTY_ITOKEN_ARRAY = new IToken[0];
    private static final boolean DEBUG_INTERNAL_GLOBALS_CACHE = false;
    private static final boolean DEBUG_GET_TOKENS_REQUESTS = false;
    private static final boolean DEBUG_LOCAL_SCOPE = false;
    public static final boolean DEBUG_FIND_DEFINITION = false;
    public static boolean TESTING = false;
    private SimpleNode ast;
    private File file;
    private Boolean bootstrap;
    public String zipFilePath;
    public final Throwable parseError;
    private long lastModified;
    private final HashMap<Integer, TreeMap<String, Object>> tokensCache = new HashMap();
    private GlobalModelVisitor globalModelVisitorCache = null;
    private Boolean hasFutureImportAbsoluteImportDeclared = null;
    private final IPythonNature nature;
    protected IFilter filter;
    private final Map<Integer, IToken[]> cacheNullValues = new HashMap<Integer, IToken[]>();
    private static final SourceToken[] EMPTY_SOURCE_TOKEN_ARRAY = new SourceToken[0];
    private Cache<Object, FindScopeVisitor> scopeVisitorCache = new LRUCache(10);
    private Cache<Object, FindDefinitionModelVisitor> findDefinitionVisitorCache = new LRUCache(10);
    public static CallbackWithListeners<ICompletionState> onFindDefinition;

    @Override
    public String getZipFilePath() {
        return this.zipFilePath;
    }

    public GlobalModelVisitor getGlobalModelVisitorCache() {
        return this.globalModelVisitorCache;
    }

    @Override
    public TokensList getWildImportedModules() {
        return new TokensList(this.getTokens(2, null));
    }

    @Override
    public TokensList getTokenImportedModules() {
        return new TokensList(this.getTokens(4, null));
    }

    public IPythonNature getNature() {
        return this.nature;
    }

    public boolean hasFutureImportAbsoluteImportDeclared() {
        if (this.hasFutureImportAbsoluteImportDeclared == null) {
            this.hasFutureImportAbsoluteImportDeclared = false;
            TokensList tokenImportedModules = this.getTokenImportedModules();
            for (IterTokenEntry entry : tokenImportedModules) {
                IToken iToken = entry.getToken();
                if (!"__future__.absolute_import".equals(iToken.getOriginalRep())) continue;
                this.hasFutureImportAbsoluteImportDeclared = true;
                break;
            }
        }
        return this.hasFutureImportAbsoluteImportDeclared;
    }

    @Override
    public File getFile() {
        return this.file;
    }

    @Override
    public TokensList getGlobalTokens() {
        return new TokensList(this.getTokens(1, null));
    }

    @Override
    public String getDocString() {
        IToken[] l = this.getTokens(8, null);
        if (l.length > 0) {
            SimpleNode a = ((SourceToken)l[0]).getAst();
            return ((Str)a).s;
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isInDirectGlobalTokens(String tok, ICompletionCache completionCache) {
        TreeMap<String, Object> tokens = this.tokensCache.get(1);
        if (tokens == null) {
            this.getGlobalTokens();
        }
        boolean ret = false;
        if (tokens != null) {
            TreeMap<String, Object> treeMap = tokens;
            synchronized (treeMap) {
                ret = tokens.containsKey(tok);
            }
        }
        if (!ret) {
            ret = this.isInDirectImportTokens(tok);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isInDirectImportTokens(String tok) {
        TreeMap<String, Object> tokens = this.tokensCache.get(4);
        if (tokens != null) {
            this.getTokenImportedModules();
        }
        boolean ret = false;
        if (tokens != null) {
            TreeMap<String, Object> treeMap = tokens;
            synchronized (treeMap) {
                ret = tokens.containsKey(tok);
            }
        }
        return ret;
    }

    protected synchronized IToken[] getTokens(int which, String lookOnlyForNameStartingWith) {
        if ((which & 0x10) != 0) {
            throw new RuntimeException("Cannot do this one with caches");
        }
        TreeMap<String, Object> tokens = this.tokensCache.get(which);
        if (tokens != null) {
            return this.createArrayFromCacheValues(which, tokens, lookOnlyForNameStartingWith);
        }
        try {
            GlobalModelVisitor globalModelVisitor;
            this.tokensCache.put(4, new TreeMap());
            this.tokensCache.put(1, new TreeMap());
            this.tokensCache.put(2, new TreeMap());
            this.tokensCache.put(8, new TreeMap());
            int all = 15;
            this.globalModelVisitorCache = globalModelVisitor = GlobalModelVisitor.getGlobalModuleVisitorWithTokens(this.ast, all, this.name, false, this.nature, this);
            List<IToken> ret = globalModelVisitor.getTokens();
            for (IToken token : ret) {
                int choice = token.isWildImport() ? 2 : (token.isImportFrom() || token.isImport() ? 4 : (token.isString() ? 8 : 1));
                if (this.filter != null && !this.filter.accept(choice, token)) continue;
                String rep = token.getRepresentation();
                TreeMap<String, Object> treeMap = this.tokensCache.get(choice);
                SourceToken newSourceToken = (SourceToken)token;
                Object current = treeMap.get(rep);
                if (current == null) {
                    treeMap.put(rep, newSourceToken);
                    continue;
                }
                if (current instanceof List) {
                    ((List)current).add(0, newSourceToken);
                    continue;
                }
                if (current instanceof SourceToken) {
                    ArrayList<SourceToken> lst = new ArrayList<SourceToken>();
                    lst.add(newSourceToken);
                    lst.add((SourceToken)current);
                    treeMap.put(rep, lst);
                    continue;
                }
                throw new RuntimeException("Unexpected class in cache:" + String.valueOf(current));
            }
        }
        catch (Exception e) {
            Log.log((Throwable)e);
        }
        tokens = this.tokensCache.get(which);
        return this.createArrayFromCacheValues(which, tokens, lookOnlyForNameStartingWith);
    }

    private IToken[] createArrayFromCacheValues(int which, TreeMap<String, Object> tokens, String lookOnlyForNameStartingWith) {
        IToken[] cachedArray;
        if (lookOnlyForNameStartingWith == null && (cachedArray = this.cacheNullValues.get(which)) != null) {
            return cachedArray;
        }
        ArrayList<SourceToken> ret = new ArrayList<SourceToken>();
        Collection<Object> lookIn = lookOnlyForNameStartingWith == null ? tokens.values() : tokens.subMap(lookOnlyForNameStartingWith, lookOnlyForNameStartingWith + "z").values();
        for (Object o : lookIn) {
            if (o instanceof SourceToken) {
                ret.add((SourceToken)o);
                continue;
            }
            if (o instanceof List) {
                ret.addAll((List)o);
                continue;
            }
            throw new RuntimeException("Unexpected class in cache:" + String.valueOf(o));
        }
        IToken[] retArray = ret.size() == 0 ? EMPTY_SOURCE_TOKEN_ARRAY : ret.toArray(new SourceToken[ret.size()]);
        if (lookOnlyForNameStartingWith == null) {
            this.cacheNullValues.put(which, retArray);
        }
        return retArray;
    }

    public SourceModule(String name, File f, SimpleNode n, Throwable parseError, IPythonNature nature) {
        super(name);
        this.ast = n;
        this.file = f;
        this.parseError = parseError;
        if (f != null) {
            this.lastModified = FileUtils.lastModified((File)f);
        }
        this.nature = nature;
    }

    @Override
    public TokensList getGlobalTokens(ICompletionState initialState, ICodeCompletionASTManager manager) {
        String activationToken = initialState.getActivationToken();
        Tuple3 key = new Tuple3((Object)"getGlobalTokens", (Object)activationToken, (Object)this);
        TokensList curr = (TokensList)initialState.getObj((Object)key);
        if (curr != null) {
            return curr;
        }
        TokensList tokens = this.internalCalculateGlobalTokens(initialState, manager);
        initialState.add((Object)key, (Object)tokens.copy());
        return tokens;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public TokensList internalCalculateGlobalTokens(ICompletionState initialState, ICodeCompletionASTManager manager) {
        String activationToken = initialState.getActivationToken();
        int activationTokenLen = activationToken.length();
        List actToks = StringUtils.dotSplit((String)activationToken);
        int actToksLen = actToks.size();
        String goFor = null;
        if (actToksLen > 0) {
            goFor = (String)actToks.get(0);
        }
        IToken[] t = this.getTokens(1, goFor);
        if (activationTokenLen == 0) {
            return new TokensList(t);
        }
        ICompletionState.LookingFor lookingFor = null;
        int i = 0;
        while (i < t.length) {
            SourceToken token = (SourceToken)t[i];
            String rep = token.getRepresentation();
            SimpleNode ast = token.getAst();
            if (activationTokenLen > rep.length() && activationToken.startsWith(rep)) {
                int iActTok = 0;
                if (((String)actToks.get(iActTok)).equals(rep)) {
                    try {
                        Object value = activationToken;
                        String initialValue = null;
                        while (!((String)value).equals(initialValue)) {
                            initialValue = value;
                            if (iActTok > actToksLen) break;
                            Definition[] definitions = this.findDefinition(initialState.getCopyWithActTok((String)value), token.getLineDefinition(), token.getColDefinition() + 1, manager.getNature());
                            if (definitions.length != 1) return this.getValueCompletions(initialState, manager, (String)value, this);
                            Definition d = definitions[0];
                            if (d instanceof TypeInfoDefinition) {
                                TypeInfoDefinition typeInfoDefinition = (TypeInfoDefinition)d;
                                ArrayList<TypeInfo> lookForClass = new ArrayList<TypeInfo>();
                                TypeInfo info = typeInfoDefinition.info;
                                lookForClass.add(info);
                                TokensList completionsForClassInLocalScope = manager.getCompletionsForClassInLocalScope(d.module, initialState.getCopyWithActTok(info.getActTok(), d.line - 1, d.col - 1), true, false, lookForClass);
                                completionsForClassInLocalScope.setLookingFor(ICompletionState.LookingFor.LOOKING_FOR_INSTANCED_VARIABLE);
                                return completionsForClassInLocalScope;
                            }
                            if (d.ast instanceof Assign) {
                                ClassDef classDef;
                                Assign assign = (Assign)d.ast;
                                if (assign.targets.length == 1 && assign.targets[0] instanceof Name && NodeUtils.isEnum((ClassDef)(classDef = (ClassDef)d.scope.getClassDef()))) {
                                    TokensList toks = ((SourceModule)d.module).getClassToks(initialState, manager, classDef);
                                    toks.setLookingFor(ICompletionState.LookingFor.LOOKING_FOR_INSTANCED_VARIABLE);
                                    return toks;
                                }
                                if (assign.value instanceof Call) {
                                    lookingFor = ICompletionState.LookingFor.LOOKING_FOR_INSTANCED_VARIABLE;
                                }
                                if (assign.type != null) {
                                    value = NodeUtils.getRepresentationString((ISimpleNode)assign.type);
                                    lookingFor = ICompletionState.LookingFor.LOOKING_FOR_INSTANCED_VARIABLE;
                                } else if (assign.value != null) {
                                    value = NodeUtils.getRepresentationString((ISimpleNode)assign.value);
                                }
                                if (value == null) break;
                                definitions = this.findDefinition(initialState.getCopyWithActTok((String)value), d.line, d.col, manager.getNature());
                            } else if (d.ast instanceof ClassDef) {
                                TokensList toks = ((SourceModule)d.module).getClassToks(initialState, manager, (ClassDef)d.ast);
                                if (lookingFor != null) {
                                    toks.setLookingFor(lookingFor);
                                }
                                if (iActTok == actToksLen - 1) {
                                    return toks;
                                }
                                value = d.value;
                            } else if (d.ast instanceof Name) {
                                ClassDef classDef = (ClassDef)d.scope.getClassDef();
                                if (classDef != null) {
                                    if (NodeUtils.isEnum((ClassDef)classDef)) {
                                        TokensList toks = ((SourceModule)d.module).getClassToks(initialState, manager, classDef);
                                        toks.setLookingFor(ICompletionState.LookingFor.LOOKING_FOR_INSTANCED_VARIABLE);
                                        return toks;
                                    }
                                    FindDefinitionModelVisitor visitor = new FindDefinitionModelVisitor((String)actToks.get(actToksLen - 1), d.line, d.col, d.module, initialState.getNature());
                                    try {
                                        classDef.accept((VisitorIF)visitor);
                                    }
                                    catch (StopVisitingException toks) {
                                        // empty catch block
                                    }
                                    if (visitor.definitions.size() == 0) {
                                        return new TokensList(EMPTY_ITOKEN_ARRAY);
                                    }
                                    d = visitor.definitions.get(0);
                                    value = d.value;
                                    if (d instanceof AssignOrTypeAliasDefinition) {
                                        initialState.setLookingFor(ICompletionState.LookingFor.LOOKING_FOR_ASSIGN, true);
                                        return this.getValueCompletions(initialState, manager, (String)value, d.module);
                                    }
                                } else if (d.module instanceof SourceModule) {
                                    SourceModule m = (SourceModule)d.module;
                                    String joined = FullRepIterable.joinFirstParts((List)actToks);
                                    Definition[] definitions2 = m.findDefinition(initialState.getCopyWithActTok(joined), d.line, d.col, manager.getNature());
                                    if (definitions2.length == 0) {
                                        return new TokensList(EMPTY_ITOKEN_ARRAY);
                                    }
                                    d = definitions2[0];
                                    value = d.value + "." + (String)actToks.get(actToksLen - 1);
                                    if (d instanceof AssignOrTypeAliasDefinition) {
                                        return ((SourceModule)d.module).getValueCompletions(initialState, manager, (String)value, d.module);
                                    }
                                }
                            } else {
                                if ((d.ast != null || d.module == null) && !(d.ast instanceof ImportFrom)) break;
                                return this.getValueCompletions(initialState, manager, (String)value, d.module);
                            }
                            ++iActTok;
                        }
                    }
                    catch (CompletionRecursionException definitions) {
                    }
                    catch (Exception e) {
                        Log.log((Throwable)e);
                    }
                }
            } else if (rep.equals(activationToken)) {
                TokensList classToks;
                if (ast instanceof ClassDef) {
                    classToks = this.getClassToks(initialState, manager, (ClassDef)ast);
                    initialState.setLookingFor(ICompletionState.LookingFor.LOOKING_FOR_UNBOUND_VARIABLE);
                    classToks.setLookingFor(initialState.getLookingFor());
                } else if (ast instanceof FunctionDef) {
                    try {
                        classToks = manager.getCompletionFromFuncDefReturn(initialState, (IModule)this, (ISimpleNode)ast, false);
                    }
                    catch (CompletionRecursionException e) {
                        classToks = new TokensList();
                    }
                    catch (Exception e) {
                        classToks = new TokensList();
                        Log.log((Throwable)e);
                    }
                } else {
                    classToks = this.getInnerToks(initialState, manager, ast);
                }
                if (!classToks.empty()) return classToks;
                if (initialState.getLookingFor() != ICompletionState.LookingFor.LOOKING_FOR_ASSIGN) {
                    return new TokensList();
                }
            }
            ++i;
        }
        return new TokensList(EMPTY_ITOKEN_ARRAY);
    }

    public TokensList getClassToks(ICompletionState initialState, ICodeCompletionASTManager manager, ClassDef classDef) {
        ClassDefTokensExtractor classTokensExtractor = new ClassDefTokensExtractor(classDef, this, initialState);
        return classTokensExtractor.getTokens(manager);
    }

    public TokensList getInnerToks(ICompletionState initialState, ICodeCompletionASTManager manager, SimpleNode ast) {
        String moduleName = this.name;
        TokensList modToks = new TokensList(GlobalModelVisitor.getTokens(ast, 16, moduleName, initialState, false, this.nature, this));
        modToks.setLookingFor(initialState.getLookingFor());
        return modToks;
    }

    private TokensList getValueCompletions(ICompletionState initialState, ICodeCompletionASTManager manager, String value, IModule module) throws CompletionRecursionException {
        initialState.checkFindMemory((IModule)this, value);
        ICompletionState copy = initialState.getCopy();
        copy.setActivationToken(value);
        TokensList completionsForModule = manager.getCompletionsForModule(module, copy);
        return completionsForModule;
    }

    private FindScopeVisitor getScopeVisitor(int line, int col) throws Exception {
        Tuple key = new Tuple((Object)line, (Object)col);
        FindScopeVisitor scopeVisitor = (FindScopeVisitor)((Object)this.scopeVisitorCache.getObj((Object)key));
        if (scopeVisitor == null) {
            scopeVisitor = new FindScopeVisitor(line, col, this.nature, this);
            if (this.ast != null) {
                this.ast.accept((VisitorIF)scopeVisitor);
            }
            this.scopeVisitorCache.add((Object)key, (Object)scopeVisitor);
        }
        return scopeVisitor;
    }

    private FindDefinitionModelVisitor getFindDefinitionsScopeVisitor(String rep, int line, int col, IPythonNature nature) throws Exception {
        Tuple3 key = new Tuple3((Object)rep, (Object)line, (Object)col);
        FindDefinitionModelVisitor visitor = (FindDefinitionModelVisitor)((Object)this.findDefinitionVisitorCache.getObj((Object)key));
        if (visitor == null) {
            visitor = new FindDefinitionModelVisitor(rep, line, col, this, nature);
            if (this.ast != null) {
                try {
                    this.ast.accept((VisitorIF)visitor);
                }
                catch (StopVisitingException stopVisitingException) {
                    // empty catch block
                }
            }
            this.findDefinitionVisitorCache.add((Object)key, (Object)visitor);
        }
        return visitor;
    }

    @Override
    public Definition[] findDefinition(ICompletionState state, int line, int col, IPythonNature nature) throws Exception {
        ICompletionState completionCache = state;
        TupleN key = new TupleN(new Object[]{state.getActivationToken(), line, col, this});
        Definition[] found = (Definition[])completionCache.getObj((Object)key);
        if (found != null) {
            return found;
        }
        Throwable throwable = null;
        Object var9_10 = null;
        try (NoExceptionCloseable x = state.pushLookingFor(ICompletionState.LookingFor.LOOKING_FOR_INSTANCE_UNDEFINED);){
            Definition[] ret = this.findDefinition(state, line, col, nature, new HashSet());
            state.add((Object)key, (Object)ret);
            return ret;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private Definition[] findDefinition(ICompletionState state, int line, int col, IPythonNature nature, Set innerFindPaths) throws Exception {
        String classRep;
        ClassDef classDef;
        Object definitions;
        Object tok;
        state.checkMaxTimeForCompletion();
        if (onFindDefinition != null) {
            onFindDefinition.call((Object)state);
        }
        String actTok = state.getActivationToken();
        Tuple3 key = new Tuple3((Object)"findDefinition", (Object)this.getName(), (Object)actTok);
        if (!innerFindPaths.add(key)) {
            return new Definition[0];
        }
        if (actTok == null || actTok.length() == 0) {
            return new Definition[]{new Definition(1, 1, "", null, null, this)};
        }
        DefinitionsContainer toRet = new DefinitionsContainer();
        FindScopeVisitor scopeVisitor = this.getScopeVisitor(line, col);
        Object objClassDef = scopeVisitor.scope.getClassDef();
        if (objClassDef instanceof ClassDef) {
            ClassDef classDef2 = (ClassDef)objClassDef;
            if (actTok.equals("super")) {
                if (classDef2.bases != null) {
                    ArrayList<Definition> lst = new ArrayList<Definition>(classDef2.bases.length);
                    exprType[] exprTypeArray = classDef2.bases;
                    int n = classDef2.bases.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Definition[] defs;
                        exprType expr = exprTypeArray[n2];
                        String repr = NodeUtils.getRepresentationString((ISimpleNode)expr);
                        if (repr != null && (defs = this.findDefinition(state = state.getCopyWithActTok(repr), line, col, nature)) != null && defs.length > 0) {
                            lst.addAll(Arrays.asList(defs));
                        }
                        ++n2;
                    }
                    if (lst.size() > 0) {
                        return lst.toArray(new Definition[lst.size()]);
                    }
                }
                return new Definition[0];
            }
            if (actTok.startsWith("super()") && classDef2.bases != null) {
                ArrayList<Definition> lst = new ArrayList<Definition>(classDef2.bases.length);
                exprType[] exprTypeArray = classDef2.bases;
                int n = classDef2.bases.length;
                int n3 = 0;
                while (n3 < n) {
                    Definition[] defs;
                    exprType expr = exprTypeArray[n3];
                    String repr = NodeUtils.getRepresentationString((ISimpleNode)expr);
                    if (repr != null && (defs = this.findDefinition(state = state.getCopyWithActTok(actTok.replace("super()", repr)), line, col, nature)) != null && defs.length > 0) {
                        lst.addAll(Arrays.asList(defs));
                    }
                    ++n3;
                }
                if (lst.size() > 0) {
                    return lst.toArray(new Definition[lst.size()]);
                }
            }
        }
        FindDefinitionModelVisitor visitor = this.getFindDefinitionsScopeVisitor(actTok, line, col, nature);
        List<Definition> defs = visitor.definitions;
        int size = defs.size();
        if (size > 0) {
            int i = 0;
            while (i < size) {
                Definition next = defs.get(i);
                if (next instanceof AssignOrTypeAliasDefinition) {
                    AssignOrTypeAliasDefinition element = (AssignOrTypeAliasDefinition)next;
                    if (!element.target.startsWith("self")) {
                        if (element.scope.isOuterOrSameScope(scopeVisitor.scope) || element.foundAsGlobal) {
                            toRet.addOptional(element);
                        }
                    } else {
                        toRet.addOptional(element);
                    }
                } else {
                    toRet.addOptional(next);
                }
                ++i;
            }
        }
        if (toRet.optionalIsParamOrTypeAlias) {
            return toRet.toArray();
        }
        TokensList localTokens = scopeVisitor.scope.getAllLocalTokens();
        for (IterTokenEntry entry : localTokens) {
            tok = entry.getToken();
            String tokenRep = tok.getRepresentation();
            if (tokenRep.equals(actTok)) {
                if (tok instanceof SourceToken) {
                    String target;
                    TypeAlias node;
                    SourceToken sourceToken = (SourceToken)tok;
                    SimpleNode sourceTokenAst = sourceToken.getAst();
                    if (sourceToken.type == 5) {
                        toRet.add(new Definition((IToken)tok, scopeVisitor.scope, this, true));
                        continue;
                    }
                    if (sourceToken.getFoundInTypeAlias() != null) {
                        node = sourceToken.getFoundInTypeAlias();
                        target = tok.getRepresentation();
                        toRet.add(FindDefinitionModelVisitor.getAssignDefinition(node, target, 0, line, col, scopeVisitor.scope, (IModule)this, -1));
                        continue;
                    }
                    if (sourceTokenAst instanceof Assign) {
                        node = (Assign)sourceTokenAst;
                        target = tok.getRepresentation();
                        toRet.add(FindDefinitionModelVisitor.getAssignDefinition((Assign)node, target, 0, line, col, scopeVisitor.scope, (IModule)this, FindDefinitionModelVisitor.findUnpackPos((Assign)node, target)));
                        continue;
                    }
                    Assign foundInAssign = sourceToken.getFoundInAssign();
                    if (foundInAssign != null) {
                        toRet.add(FindDefinitionModelVisitor.getAssignDefinition(foundInAssign, actTok, 0, sourceTokenAst.beginLine, sourceTokenAst.beginColumn, scopeVisitor.scope, (IModule)this, FindDefinitionModelVisitor.findUnpackPos(foundInAssign, tok.getRepresentation())));
                        continue;
                    }
                    toRet.add(new Definition((IToken)tok, this.getScopeVisitor((int)sourceTokenAst.beginLine, (int)sourceTokenAst.beginColumn).scope, this, true));
                    continue;
                }
                toRet.add(new Definition((IToken)tok, scopeVisitor.scope, this, true));
                continue;
            }
            if (!actTok.startsWith((String)tokenRep + ".") || actTok.startsWith("self.")) continue;
            int tokenRepLen = tokenRep.length();
            state.checkFindLocalDefinedDefinitionMemory((IModule)this, tokenRep);
            ICompletionState copyWithActTok = state.getCopyWithActTok(tokenRep);
            definitions = this.findDefinition(copyWithActTok, tok.getLineDefinition(), tok.getColDefinition(), nature, innerFindPaths);
            Definition[] definitionArray = definitions;
            int n = ((Definition[])definitions).length;
            int n4 = 0;
            while (n4 < n) {
                Definition definition = definitionArray[n4];
                if (definition.module != null && definition.value.length() != 0) {
                    String checkFor = definition.value + actTok.substring(tokenRepLen);
                    if (!this.equals(definition.module) || !actTok.equals(definition.value) && !checkFor.equals(actTok) && !checkFor.startsWith(actTok + ".")) {
                        Definition[] realDefinitions;
                        int dotsFound = StringUtils.count((String)checkFor, (char)'.');
                        if (dotsFound > 15) {
                            throw new CompletionRecursionException("Trying to go to deep to find definition.\nWe probably started entering a recursion.\nModule: " + definition.module.getName() + "\nToken: " + (String)checkFor);
                        }
                        if (definition.module instanceof SourceModule) {
                            SourceModule sourceModule = (SourceModule)definition.module;
                            realDefinitions = sourceModule.findDefinition(state.getCopyWithActTok(checkFor), definition.line, definition.col, nature, innerFindPaths);
                        } else {
                            realDefinitions = (Definition[])definition.module.findDefinition(state.getCopyWithActTok(checkFor), definition.line, definition.col, nature);
                        }
                        Definition[] definitionArray2 = realDefinitions;
                        int n5 = realDefinitions.length;
                        int n6 = 0;
                        while (n6 < n5) {
                            Definition realDefinition = definitionArray2[n6];
                            toRet.add(realDefinition);
                            ++n6;
                        }
                    }
                }
                ++n4;
            }
            if (toRet.empty()) {
                ILocalScope scope = scopeVisitor.scope;
                List possibleClassesForActivationToken = scope.getPossibleClassesForActivationToken(tokenRep);
                String remainder = actTok.substring(tokenRepLen + 1);
                if (possibleClassesForActivationToken.size() > 0) {
                    for (ITypeInfo possibleClass : possibleClassesForActivationToken) {
                        AbstractASTManager astManager = (AbstractASTManager)nature.getAstManager();
                        if (astManager == null) continue;
                        TokensList completionsFromTypeRepresentation = astManager.getCompletionsFromTypeRepresentation(state, Arrays.asList(possibleClass), this);
                        for (IterTokenEntry entry1 : completionsFromTypeRepresentation) {
                            IToken iToken = entry1.getToken();
                            if (!remainder.equals(iToken.getRepresentation())) continue;
                            String parentPackage = iToken.getParentPackage();
                            SourceModule module = this.getName().equals(parentPackage) ? this : astManager.getModule(parentPackage, nature, true, (IModuleRequestState)state);
                            if (module == null) continue;
                            toRet.add(new Definition(iToken, null, module));
                        }
                    }
                }
            }
            return toRet.toArray();
        }
        TokensList localImportedModules = scopeVisitor.scope.getLocalImportedModules(line, col, this.name);
        ICodeCompletionASTManager astManager = nature.getAstManager();
        for (IterTokenEntry entry : localImportedModules) {
            IToken tok2 = entry.getToken();
            String importRep = tok2.getRepresentation();
            if (!importRep.equals(actTok) && !actTok.startsWith(importRep + ".")) continue;
            Tuple3 o = astManager.findOnImportedMods(new TokensList(new IToken[]{tok2}), state.getCopyWithActTok(actTok), this.getName(), (IModule)this);
            if (o != null && o.o1 instanceof SourceModule) {
                ICompletionState copy = state.getCopy();
                copy.setActivationToken((String)o.o2);
                this.findDefinitionsFromModAndTok(nature, toRet, null, (SourceModule)o.o1, copy);
            }
            if (toRet.empty()) continue;
            return toRet.toArray();
        }
        if (actTok.startsWith("self.") && (classDef = (ClassDef)scopeVisitor.scope.getClassDef()) != null && (classRep = NodeUtils.getRepresentationString((ISimpleNode)classDef)) != null) {
            TokensList globalTokens = this.getGlobalTokens(state.getCopyWithActTok(classRep, line - 1, col - 1), astManager);
            String withoutSelf = actTok.substring(5);
            definitions = new ArrayList();
            for (IterTokenEntry entry : globalTokens) {
                ILocalScope scope;
                IToken token = entry.getToken();
                if (!token.getRepresentation().equals(withoutSelf)) continue;
                String parentPackage = token.getParentPackage();
                IModule module = astManager.getModule(parentPackage, nature, true, (IModuleRequestState)state);
                if (!(token instanceof SourceToken) || module == null && this.name != null && !this.name.equals(parentPackage)) continue;
                if (module == null) {
                    module = this;
                }
                SourceToken sourceToken = (SourceToken)token;
                SimpleNode ast2 = sourceToken.getAst();
                Tuple<Integer, Integer> def = this.getLineColForDefinition(ast2);
                if (module instanceof SourceModule) {
                    SourceModule sourceModule = (SourceModule)module;
                    scope = sourceModule.getLocalScope(ast2.beginLine, ast2.beginColumn);
                } else {
                    FastStack stack = new FastStack(5);
                    stack.push((Object)classDef);
                    scope = new LocalScope(astManager.getNature(), (FastStack<SimpleNode>)new FastStack(0), module);
                }
                Assign foundInAssign = sourceToken.getFoundInAssign();
                if (foundInAssign != null) {
                    definitions.add(FindDefinitionModelVisitor.getAssignDefinition(foundInAssign, actTok, col, ast2.beginLine, ast2.beginColumn, scope, module, -1));
                    continue;
                }
                definitions.add(new Definition((Integer)def.o1, (Integer)def.o2, token.getRepresentation(), ast2, scope, module));
            }
            if (definitions.size() > 0) {
                return definitions.toArray(new Definition[0]);
            }
        }
        tok = actTok;
        SourceModule mod = this;
        Tuple3 o = astManager.findOnImportedMods(state.getCopyWithActTok(actTok), (IModule)this);
        if (o != null) {
            if (o.o1 instanceof SourceModule) {
                mod = (SourceModule)o.o1;
                tok = (String)o.o2;
            } else {
                if (o.o1 instanceof CompiledModule) {
                    tok = (String)o.o2;
                    if (tok == null || ((String)tok).length() == 0) {
                        return new Definition[]{new Definition(1, 1, "", null, null, (IModule)o.o1)};
                    }
                    state.checkFindDefinitionMemory((IModule)o.o1, (String)tok);
                    return (Definition[])((IModule)o.o1).findDefinition(state.getCopyWithActTok((String)tok), -1, -1, nature);
                }
                if (o.o1 instanceof IAbstractJavaClassModule) {
                    tok = (String)o.o2;
                    state.checkFindDefinitionMemory((IModule)o.o1, (String)tok);
                    return (Definition[])((IModule)o.o1).findDefinition(state.getCopyWithActTok((String)tok), -1, -1, nature);
                }
                throw new RuntimeException("Unexpected module found in imports: " + String.valueOf(o));
            }
        }
        ICompletionState copy = state.getCopyWithActTok((String)tok, line - 1, col - 1);
        try {
            state.checkFindDefinitionMemory((IModule)mod, (String)tok);
            this.findDefinitionsFromModAndTok(nature, toRet, visitor.moduleImported, mod, copy);
        }
        catch (CompletionRecursionException completionRecursionException) {
            // empty catch block
        }
        return toRet.toArray();
    }

    private void findDefinitionsFromModAndTok(IPythonNature nature, DefinitionsContainer toRet, String moduleImported, SourceModule mod, ICompletionState state) throws Exception {
        String tok = state.getActivationToken();
        if (tok != null) {
            if (tok.length() > 0) {
                Definition d = mod.findGlobalTokDef(state.getCopyWithActTok(tok, state.getLine(), state.getCol()), nature);
                if (d != null) {
                    toRet.add(d);
                } else if (moduleImported != null) {
                    this.getModuleDefinition(nature, toRet, mod, moduleImported, (IModuleRequestState)state);
                }
            } else {
                toRet.add(new Definition(1, 1, "", null, null, mod));
            }
        }
    }

    private IDefinition getModuleDefinition(IPythonNature nature, DefinitionsContainer toRet, SourceModule mod, String moduleImported, IModuleRequestState moduleRequest) {
        String rel = AbstractToken.makeRelative(mod.getName(), moduleImported);
        IModule modFound = nature.getAstManager().getModule(rel, nature, false, moduleRequest);
        if (modFound == null) {
            modFound = nature.getAstManager().getModule(moduleImported, nature, false, moduleRequest);
        }
        if (modFound != null) {
            Definition definition = new Definition(1, 1, "", null, null, modFound);
            if (toRet != null) {
                toRet.add(definition);
            }
            return definition;
        }
        return null;
    }

    private Definition findGlobalTokDef(ICompletionState state, IPythonNature nature) throws Exception {
        Tuple3 key = new Tuple3((Object)"findGlobalTokDef", (Object)state.getActivationToken(), (Object)this);
        Object obj = state.getObj((Object)key);
        if (obj != null) {
            return ((DefinitionRef)obj).get();
        }
        Definition found = this.internalFindGlobalTokDef(state, nature);
        state.add((Object)key, (Object)new DefinitionRef(found));
        return found;
    }

    private Definition internalFindGlobalTokDef(ICompletionState state, IPythonNature nature) throws Exception {
        String tok = state.getActivationToken();
        String[] headAndTail = FullRepIterable.headAndTail((String)tok);
        String firstPart = headAndTail[0];
        String rep = headAndTail[1];
        TokensList tokens = null;
        if (tokens == null || tokens.empty()) {
            tokens = nature != null ? nature.getAstManager().getCompletionsForModule((IModule)this, state.getCopyWithActTok(firstPart, state.getLine(), state.getCol()), true) : this.getGlobalTokens();
        }
        for (IterTokenEntry entry : tokens) {
            IToken token = entry.getToken();
            boolean sameRep = token.getRepresentation().equals(rep);
            if (!sameRep) continue;
            if (token instanceof SourceToken) {
                IModule mod;
                SimpleNode a;
                SourceToken sourceToken = (SourceToken)token;
                if (sourceToken.getType() == 10 || (a = sourceToken.getAst()) == null) continue;
                Tuple<Integer, Integer> def = this.getLineColForDefinition(a);
                String parentPackage = token.getParentPackage();
                Object module = this;
                if (nature != null && (mod = nature.getAstManager().getModule(parentPackage, nature, true, (IModuleRequestState)state)) != null) {
                    module = mod;
                }
                if (module instanceof SourceModule) {
                    SourceModule m = (SourceModule)module;
                    FindScopeVisitor scopeVisitor = m.getScopeVisitor(a.beginLine, a.beginColumn);
                    Assign foundInAssign = sourceToken.getFoundInAssign();
                    if (foundInAssign != null) {
                        String fullRep;
                        Definition ret = this.findDefinitionsInAssignStatementUncached(nature, rep, m, foundInAssign);
                        if (ret == null && !rep.equals(fullRep = NodeUtils.getFullRepresentationString((SimpleNode)sourceToken.getAst()))) {
                            ret = this.findDefinitionsInAssignStatementUncached(nature, fullRep, m, foundInAssign);
                        }
                        if (ret != null) {
                            ret.scope = scopeVisitor.scope;
                        }
                        return ret;
                    }
                    return new Definition((Integer)def.o1, (Integer)def.o2, rep, a, scopeVisitor.scope, (IModule)module);
                }
                return new Definition((Integer)def.o1, (Integer)def.o2, rep, a, new LocalScope(nature, (FastStack<SimpleNode>)new FastStack(5), (IModule)module), (IModule)module);
            }
            if (token instanceof ConcreteToken) {
                Object modName = token.getParentPackage();
                if (((String)modName).length() > 0) {
                    modName = (String)modName + ".";
                }
                modName = (String)modName + token.getRepresentation();
                IModule module = nature.getAstManager().getModule((String)modName, nature, true, (IModuleRequestState)state);
                if (module == null) {
                    return null;
                }
                return new Definition(1, 1, "", null, null, module);
            }
            if (token instanceof CompiledToken) {
                String parentPackage = token.getParentPackage();
                FullRepIterable iterable = new FullRepIterable(parentPackage, true);
                IModule module = null;
                for (String modName : iterable) {
                    module = nature.getAstManager().getModule(modName, nature, true, (IModuleRequestState)state);
                    if (module != null) break;
                }
                if (module == null) {
                    return null;
                }
                int length = module.getName().length();
                Object finalRep = "";
                if (parentPackage.length() > length) {
                    finalRep = parentPackage.substring(length + 1) + ".";
                }
                finalRep = (String)finalRep + token.getRepresentation();
                try {
                    IDefinition[] definitions = module.findDefinition(state.getCopyWithActTok((String)finalRep), -1, -1, nature);
                    if (definitions.length <= 0) continue;
                    Definition definition = (Definition)definitions[0];
                    definition.setGeneratorType(token.getGeneratorType());
                    return definition;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            throw new RuntimeException("Unexpected token:" + String.valueOf(token.getClass()));
        }
        return null;
    }

    private Definition findDefinitionsInAssignStatementUncached(IPythonNature nature, String rep, SourceModule m, Assign foundInAssign) throws Exception {
        FindDefinitionModelVisitor visitor = new FindDefinitionModelVisitor(rep, foundInAssign.beginLine, foundInAssign.beginColumn, m, nature);
        try {
            foundInAssign.accept((VisitorIF)visitor);
        }
        catch (StopVisitingException stopVisitingException) {
            // empty catch block
        }
        List<Definition> definitions = visitor.definitions;
        if (definitions == null || definitions.size() == 0) {
            return null;
        }
        return definitions.get(0);
    }

    public Tuple<Integer, Integer> getLineColForDefinition(SimpleNode a) {
        int line = a.beginLine;
        int col = a.beginColumn;
        if (a instanceof ClassDef) {
            ClassDef c = (ClassDef)a;
            line = c.name.beginLine;
            col = c.name.beginColumn;
        } else if (a instanceof FunctionDef) {
            FunctionDef c = (FunctionDef)a;
            line = c.name.beginLine;
            col = c.name.beginColumn;
        }
        return new Tuple((Object)line, (Object)col);
    }

    @Override
    public TokensList getLocalTokens(int line, int col, ILocalScope scope) {
        try {
            if (scope == null) {
                FindScopeVisitor scopeVisitor = this.getScopeVisitor(line + 1, col + 1);
                scope = scopeVisitor.scope;
            }
            return scope.getLocalTokens(line + 1, col + 1, false);
        }
        catch (Exception e) {
            Log.log((Throwable)e);
            return new TokensList();
        }
    }

    @Override
    public ILocalScope getLocalScope(int line, int col) {
        try {
            FindScopeVisitor scopeVisitor = this.getScopeVisitor(line + 1, col + 1);
            return scopeVisitor.scope;
        }
        catch (Exception e) {
            Log.log((Throwable)e);
            return null;
        }
    }

    public boolean isSynched() {
        if (this.file == null && TESTING) {
            return true;
        }
        return FileUtils.lastModified((File)this.file) == this.lastModified;
    }

    public SimpleNode getAst() {
        return this.ast;
    }

    public int findAstEnd(SimpleNode node) {
        try {
            FindScopeVisitor scopeVisitor = this.getScopeVisitor(node.beginLine, node.beginColumn);
            return scopeVisitor.scope.getScopeEndLine();
        }
        catch (Exception e) {
            Log.log((Throwable)e);
            return -1;
        }
    }

    public int findIfMain() {
        try {
            FindScopeVisitor scopeVisitor = this.getScopeVisitor(-1, -1);
            return scopeVisitor.scope.getIfMainLine();
        }
        catch (Exception e) {
            Log.log((Throwable)e);
            return -1;
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof SourceModule)) {
            return false;
        }
        SourceModule m = (SourceModule)obj;
        if (this.name == null || m.name == null ? this.name != m.name : !this.name.equals(m.name)) {
            return false;
        }
        if (this.zipFilePath == null || m.zipFilePath == null ? this.zipFilePath != m.zipFilePath : !this.zipFilePath.equals(m.zipFilePath)) {
            return false;
        }
        return !(this.file == null || m.file == null ? this.file != m.file : !this.file.equals(m.file));
    }

    @Override
    public int hashCode() {
        int hash = 77;
        if (this.file != null) {
            hash += this.file.hashCode();
        }
        if (this.name != null) {
            hash += this.name.hashCode();
        }
        if (this.zipFilePath != null) {
            hash += this.zipFilePath.hashCode();
        }
        return hash;
    }

    public void setName(String n) {
        this.name = n;
    }

    public boolean isBootstrapModule() {
        if (this.bootstrap == null) {
            TokensList ret = this.getGlobalTokens();
            if (ret != null && ret.size() >= 1 && ret.size() <= 3 && this.file != null) {
                for (IterTokenEntry entry : ret) {
                    Call call;
                    String callRep;
                    SimpleNode ast;
                    IToken tok = entry.getToken();
                    if (!"__bootstrap__".equals(tok.getRepresentation()) || !((ast = this.getAst()) instanceof Module)) continue;
                    Module module = (Module)ast;
                    if (module.body == null || module.body.length <= 0 || !((ast = module.body[module.body.length - 1]) instanceof Expr)) continue;
                    Expr expr = (Expr)ast;
                    ast = expr.value;
                    if (!(ast instanceof Call) || (callRep = NodeUtils.getRepresentationString((ISimpleNode)(call = (Call)ast))) == null || !callRep.equals("__bootstrap__")) continue;
                    final String modName = FullRepIterable.getLastPart((String)this.getName());
                    File folder = this.file.getParentFile();
                    File[] validBootsrappedDlls = folder.listFiles(new FilenameFilter(){

                        @Override
                        public boolean accept(File dir, String name) {
                            String extension;
                            String namePart;
                            int i = name.lastIndexOf(46);
                            return i > 0 && (namePart = name.substring(0, i)).equals(modName) && (extension = name.substring(i + 1)).length() > 0 && FileTypesPreferences.isValidDllExtension((String)extension);
                        }
                    });
                    if (validBootsrappedDlls == null || validBootsrappedDlls.length <= 0) continue;
                    this.bootstrap = Boolean.TRUE;
                    break;
                }
            }
            if (this.bootstrap == null) {
                this.bootstrap = Boolean.FALSE;
            }
        }
        return this.bootstrap;
    }

    public ModulesKey getModulesKey() {
        if (this.zipFilePath != null && this.zipFilePath.length() > 0) {
            return new ModulesKeyForZip(this.name, this.file, this.zipFilePath, true);
        }
        return new ModulesKey(this.name, this.file);
    }

    private class DefinitionRef {
        private Definition found;

        public DefinitionRef(Definition found) {
            this.found = found;
        }

        public Definition get() {
            return this.found;
        }
    }

    private static class DefinitionsContainer {
        private static final Definition[] EMPTY_DEFINITION = new Definition[0];
        private List<Definition> list = null;
        private Set<LineCol> memo = null;
        private List<Definition> optional = null;
        public boolean optionalIsParamOrTypeAlias;

        public void add(Definition definition) {
            LineCol lineCol = new LineCol(definition.line, definition.col);
            if (this.list == null) {
                this.list = new ArrayList<Definition>(4);
                this.list.add(definition);
                this.memo = new HashSet<LineCol>();
                this.memo.add(lineCol);
            } else if (!this.memo.contains(lineCol)) {
                this.list.add(definition);
                this.memo.add(lineCol);
            }
        }

        public boolean empty() {
            return this.list == null;
        }

        public void addOptional(Definition definition) {
            if (definition instanceof KeywordParameterDefinition) {
                this.optionalIsParamOrTypeAlias = true;
            } else if (definition.ast instanceof Name) {
                Name name = (Name)definition.ast;
                this.optionalIsParamOrTypeAlias = name.ctx == 6 || name.ctx == 8;
            } else if (definition.ast instanceof NameTok) {
                NameTok name = (NameTok)definition.ast;
                this.optionalIsParamOrTypeAlias = name.ctx == 12;
            } else if (definition.ast instanceof TypeAlias) {
                this.optionalIsParamOrTypeAlias = true;
            }
            if (this.optional == null) {
                this.optional = new ArrayList<Definition>();
            }
            this.optional.add(definition);
        }

        public Definition[] toArray() {
            if (this.optional != null) {
                for (Definition d : this.optional) {
                    this.add(d);
                }
            }
            if (this.list != null && this.list.size() > 0) {
                return this.list.toArray(EMPTY_DEFINITION);
            }
            return EMPTY_DEFINITION;
        }
    }

    public static interface IFilter {
        public boolean accept(int var1, IToken var2);
    }
}

