/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.ast.codecompletion.revisited.visitors;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.python.pydev.ast.codecompletion.revisited.modules.SourceModule;
import org.python.pydev.ast.codecompletion.revisited.modules.SourceToken;
import org.python.pydev.ast.codecompletion.revisited.visitors.GlobalModelVisitor;
import org.python.pydev.ast.codecompletion.revisited.visitors.InnerModelVisitor;
import org.python.pydev.core.ICompletionState;
import org.python.pydev.core.IModule;
import org.python.pydev.core.IPythonNature;
import org.python.pydev.core.IToken;
import org.python.pydev.parser.jython.SimpleNode;
import org.python.pydev.parser.jython.ast.Import;
import org.python.pydev.parser.jython.ast.ImportFrom;
import org.python.pydev.parser.jython.ast.NameTok;
import org.python.pydev.parser.jython.ast.Str;
import org.python.pydev.parser.jython.ast.VisitorBase;
import org.python.pydev.parser.jython.ast.VisitorIF;
import org.python.pydev.parser.jython.ast.aliasType;
import org.python.pydev.parser.visitors.NodeUtils;
import org.python.pydev.shared_core.model.ISimpleNode;
import org.python.pydev.shared_core.string.FullRepIterable;

public abstract class AbstractVisitor
extends VisitorBase {
    public static final int GLOBAL_TOKENS = 1;
    public static final int WILD_MODULES = 2;
    public static final int ALIAS_MODULES = 4;
    public static final int MODULE_DOCSTRING = 8;
    public static final int INNER_DEFS = 16;
    protected final List<IToken> tokens = new ArrayList<IToken>();
    protected String moduleName;
    protected final IPythonNature nature;
    protected final WeakReference<IModule> module;

    public AbstractVisitor(IPythonNature nature, IModule module) {
        this.nature = nature;
        this.module = new WeakReference<IModule>(module);
    }

    protected SourceToken addToken(SimpleNode node) {
        SourceToken t = AbstractVisitor.makeToken(node, this.moduleName, this.nature, (IModule)this.module.get());
        this.tokens.add(t);
        return t;
    }

    public static SourceToken makeToken(SimpleNode node, String moduleName, IPythonNature nature, IModule module) {
        return new SourceToken(node, NodeUtils.getRepresentationString((ISimpleNode)node), NodeUtils.getNodeArgs((SimpleNode)node), NodeUtils.getNodeDocString((SimpleNode)node), moduleName, nature, module);
    }

    public static SourceToken makeToken(SimpleNode node, String rep, String moduleName, IPythonNature nature, IModule module) {
        return new SourceToken(node, rep, NodeUtils.getNodeArgs((SimpleNode)node), NodeUtils.getNodeDocString((SimpleNode)node), moduleName, nature, module);
    }

    public static SourceToken makeFullNameToken(SimpleNode node, String moduleName, IPythonNature nature, IModule module) {
        return new SourceToken(node, NodeUtils.getFullRepresentationString((SimpleNode)node), NodeUtils.getNodeArgs((SimpleNode)node), NodeUtils.getNodeDocString((SimpleNode)node), moduleName, nature, module);
    }

    public static IToken makeWildImportToken(ImportFrom node, List<IToken> tokens, String moduleName, IPythonNature nature, IModule module) {
        if (tokens == null) {
            tokens = new ArrayList<IToken>();
        }
        SourceToken sourceToken = null;
        if (AbstractVisitor.isWildImport(node)) {
            sourceToken = new SourceToken((SimpleNode)node, ((NameTok)node.module).id, "", "", moduleName, nature, module);
            tokens.add(sourceToken);
        }
        return sourceToken;
    }

    public static List<IToken> makeImportToken(SimpleNode node, List<IToken> tokens, String moduleName, boolean allowForMultiple, IPythonNature nature, IModule module) {
        if (node instanceof Import) {
            return AbstractVisitor.makeImportToken((Import)node, tokens, moduleName, allowForMultiple, nature, module);
        }
        if (node instanceof ImportFrom) {
            ImportFrom i = (ImportFrom)node;
            if (AbstractVisitor.isWildImport(i)) {
                AbstractVisitor.makeWildImportToken(i, tokens, moduleName, nature, module);
                return tokens;
            }
            return AbstractVisitor.makeImportToken((ImportFrom)node, tokens, moduleName, allowForMultiple, nature, module);
        }
        throw new RuntimeException("Unable to create token for the passed import (" + String.valueOf(node) + ")");
    }

    public static List<IToken> makeImportToken(Import node, List<IToken> tokens, String moduleName, boolean allowForMultiple, IPythonNature nature, IModule module) {
        aliasType[] names = node.names;
        return AbstractVisitor.makeImportToken((SimpleNode)node, tokens, names, moduleName, "", nature, module);
    }

    public static List<IToken> makeImportToken(ImportFrom node, List<IToken> tokens, String moduleName, boolean allowForMultiple, IPythonNature nature, IModule module) {
        aliasType[] names = node.names;
        String importName = ((NameTok)node.module).id;
        return AbstractVisitor.makeImportToken((SimpleNode)node, tokens, names, moduleName, importName, nature, module);
    }

    private static List<IToken> makeImportToken(SimpleNode node, List<IToken> tokens, aliasType[] names, String moduleName, String initialImportName, IPythonNature nature, IModule module) {
        if (tokens == null) {
            tokens = new ArrayList<IToken>();
        }
        if (((String)initialImportName).length() > 0) {
            initialImportName = (String)initialImportName + ".";
        }
        int i = 0;
        while (i < names.length) {
            aliasType aliasType2 = names[i];
            String name = null;
            String original = ((NameTok)aliasType2.name).id;
            if (aliasType2.asname != null) {
                name = ((NameTok)aliasType2.asname).id;
            }
            if (name == null) {
                FullRepIterable iterator = new FullRepIterable(original);
                Iterator it = iterator.iterator();
                while (it.hasNext()) {
                    String rep = (String)it.next();
                    SourceToken sourceToken = it.hasNext() ? new ImportPartSourceToken(node, rep, "", "", moduleName, (String)initialImportName + rep, true, nature, module) : new SourceToken(node, rep, "", "", moduleName, (String)initialImportName + rep, true, nature, module);
                    tokens.add(sourceToken);
                }
            } else {
                SourceToken sourceToken = new SourceToken(node, name, "", "", moduleName, (String)initialImportName + original, false, nature, module);
                tokens.add(sourceToken);
            }
            ++i;
        }
        return tokens;
    }

    public static boolean isString(SimpleNode ast) {
        return ast instanceof Str;
    }

    public static boolean isWildImport(ImportFrom node) {
        return node.names.length == 0;
    }

    public static boolean isAliasImport(ImportFrom node) {
        return node.names.length > 0;
    }

    public List<IToken> getTokens() {
        return this.tokens;
    }

    public static List<IToken> getTokens(SimpleNode ast, int which, String moduleName, ICompletionState state, boolean onlyAllowTokensIn__all__, IPythonNature nature, IModule module) {
        AbstractVisitor modelVisitor = which == 16 ? new InnerModelVisitor(moduleName, state, nature, module) : new GlobalModelVisitor(which, moduleName, onlyAllowTokensIn__all__, nature, module);
        if (ast != null) {
            try {
                ast.accept((VisitorIF)modelVisitor);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            modelVisitor.finishVisit();
            return modelVisitor.tokens;
        }
        return new ArrayList<IToken>();
    }

    public static GlobalModelVisitor getGlobalModuleVisitorWithTokens(SimpleNode ast, int which, String moduleName, boolean onlyAllowTokensIn__all__, IPythonNature nature, SourceModule sourceModule) {
        if (which == 16) {
            throw new RuntimeException("Only globals for getting the GlobalModelVisitor");
        }
        GlobalModelVisitor modelVisitor = new GlobalModelVisitor(which, moduleName, onlyAllowTokensIn__all__, nature, sourceModule);
        if (ast != null) {
            try {
                ast.accept((VisitorIF)modelVisitor);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            modelVisitor.finishVisit();
            return modelVisitor;
        }
        return modelVisitor;
    }

    protected void finishVisit() {
    }

    public static class ImportPartSourceToken
    extends SourceToken {
        private static final long serialVersionUID = 1L;

        public ImportPartSourceToken(SimpleNode node, String rep, String doc, String args, String parentPackage, String originalRep, boolean originalHasRep, IPythonNature nature, IModule module) {
            super(node, rep, doc, args, parentPackage, originalRep, originalHasRep, nature, module);
        }
    }
}

