/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.ast.codecompletion.revisited.visitors;

import java.util.ArrayList;
import java.util.Collections;
import org.python.pydev.ast.codecompletion.revisited.visitors.AbstractVisitor;
import org.python.pydev.ast.codecompletion.revisited.visitors.LocalScope;
import org.python.pydev.core.ILocalScope;
import org.python.pydev.core.IModule;
import org.python.pydev.core.IPythonNature;
import org.python.pydev.parser.jython.SimpleNode;
import org.python.pydev.parser.jython.ast.ClassDef;
import org.python.pydev.parser.jython.ast.FunctionDef;
import org.python.pydev.parser.jython.ast.If;
import org.python.pydev.parser.jython.ast.Module;
import org.python.pydev.parser.jython.ast.VisitorIF;
import org.python.pydev.parser.visitors.NodeUtils;
import org.python.pydev.shared_core.model.ISimpleNode;
import org.python.pydev.shared_core.structure.FastStack;

public class FindScopeVisitor
extends AbstractVisitor {
    protected FastStack<SimpleNode> stackScope = new FastStack(20);
    public ILocalScope scope;
    protected boolean found = false;
    private int line;
    private int col;
    private ISimpleNode lastDef;
    private IModule module;

    protected FindScopeVisitor(IPythonNature nature, IModule module) {
        super(nature, module);
        this.scope = new LocalScope(nature, (FastStack<SimpleNode>)new FastStack(20), module);
        this.module = module;
    }

    public FindScopeVisitor(int line, int col, IPythonNature nature, IModule module) {
        this(nature, module);
        this.line = line;
        this.col = col;
        this.module = module;
    }

    protected Object unhandled_node(SimpleNode node) throws Exception {
        if (!this.found && !(node instanceof Module)) {
            if (this.line <= node.beginLine) {
                this.onScopeFound(node);
            }
        } else if (this.scope.getScopeEndLine() == -1 && this.line < node.beginLine && this.col >= node.beginColumn) {
            this.scope.setScopeEndLine(node.beginLine);
        }
        return node;
    }

    private void onScopeFound(SimpleNode node) {
        this.found = true;
        int original = this.scope.getIfMainLine();
        this.scope = new LocalScope(this.nature, (FastStack<SimpleNode>)this.stackScope.createCopy(), this.module);
        this.scope.setIfMainLine(original);
        this.scope.setFoundAtASTNode((ISimpleNode)node);
    }

    public void traverse(SimpleNode node) throws Exception {
        node.traverse((VisitorIF)this);
    }

    public Object visitIf(If node) throws Exception {
        this.checkIfMainNode(node);
        return super.visitIf(node);
    }

    protected void checkIfMainNode(If node) {
        boolean isIfMainNode = NodeUtils.isIfMAinNode((If)node);
        if (isIfMainNode) {
            this.scope.setIfMainLine(node.beginLine);
        }
    }

    public Object visitClassDef(ClassDef node) throws Exception {
        if (!this.found) {
            this.lastDef = node;
            if (NodeUtils.isAfterNameEnd((ClassDef)node, (int)this.line, (int)this.col)) {
                this.stackScope.push((Object)node);
                node.traverse((VisitorIF)this);
                this.stackScope.pop();
            } else {
                this.unhandled_node((SimpleNode)node);
            }
        }
        return null;
    }

    public Object visitFunctionDef(FunctionDef node) throws Exception {
        if (!this.found) {
            this.lastDef = node;
            if (NodeUtils.isAfterNameEnd((FunctionDef)node, (int)this.line, (int)this.col)) {
                this.stackScope.push((Object)node);
                node.traverse((VisitorIF)this);
                this.stackScope.pop();
            } else {
                this.unhandled_node((SimpleNode)node);
            }
        }
        return null;
    }

    public Object visitModule(Module node) throws Exception {
        this.stackScope.push((Object)node);
        super.visitModule(node);
        if (!this.found && this.col > 1 && this.lastDef != null) {
            SimpleNode n = (SimpleNode)this.lastDef;
            ArrayList<SimpleNode> lst = new ArrayList<SimpleNode>(3);
            while (n != null && !(n instanceof Module)) {
                lst.add(n);
                n = n.parent;
            }
            Collections.reverse(lst);
            for (SimpleNode n1 : lst) {
                this.stackScope.push((Object)n1);
            }
            this.onScopeFound(null);
        }
        return null;
    }
}

