/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.ast.codecompletion.revisited.visitors;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.python.pydev.ast.codecompletion.revisited.modules.SourceToken;
import org.python.pydev.ast.codecompletion.revisited.visitors.AbstractVisitor;
import org.python.pydev.core.IModule;
import org.python.pydev.core.IPythonNature;
import org.python.pydev.core.IToken;
import org.python.pydev.parser.jython.SimpleNode;
import org.python.pydev.parser.jython.ast.Assign;
import org.python.pydev.parser.jython.ast.Call;
import org.python.pydev.parser.jython.ast.ClassDef;
import org.python.pydev.parser.jython.ast.FunctionDef;
import org.python.pydev.parser.jython.ast.Import;
import org.python.pydev.parser.jython.ast.ImportFrom;
import org.python.pydev.parser.jython.ast.Name;
import org.python.pydev.parser.jython.ast.Str;
import org.python.pydev.parser.jython.ast.Tuple;
import org.python.pydev.parser.jython.ast.TypeAlias;
import org.python.pydev.parser.jython.ast.VisitorIF;
import org.python.pydev.parser.jython.ast.exprType;
import org.python.pydev.parser.visitors.NodeUtils;
import org.python.pydev.shared_core.model.ISimpleNode;
import org.python.pydev.shared_core.structure.FastStack;

public final class GlobalModelVisitor
extends AbstractVisitor {
    private final int visitWhat;
    private final FastStack<Assign> lastAssign = new FastStack(20);
    private final FastStack<Call> lastCall = new FastStack(20);
    private final boolean onlyAllowTokensIn__all__;
    private final Map<String, SourceToken> repToTokenWithArgs = new HashMap<String, SourceToken>();
    private SourceToken __all__;
    private Assign __all__Assign;
    private exprType[] __all__AssignTargets;
    private final IModule module;

    public GlobalModelVisitor(int visitWhat, String moduleName, boolean onlyAllowTokensIn__all__, IPythonNature nature, IModule module) {
        this(visitWhat, moduleName, onlyAllowTokensIn__all__, false, nature, module);
    }

    public GlobalModelVisitor(int visitWhat, String moduleName, boolean onlyAllowTokensIn__all__, boolean lookingInLocalContext, IPythonNature nature, IModule module) {
        super(nature, module);
        this.module = module;
        this.visitWhat = visitWhat;
        this.moduleName = moduleName;
        this.onlyAllowTokensIn__all__ = onlyAllowTokensIn__all__;
        this.tokens.add(new SourceToken((SimpleNode)new Name("__dict__", 1, false), "__dict__", "", "", moduleName, nature, module));
        if (moduleName != null && moduleName.endsWith("__init__")) {
            this.tokens.add(new SourceToken((SimpleNode)new Name("__path__", 1, false), "__path__", "", "", moduleName, nature, module));
        }
        if (!lookingInLocalContext && (this.visitWhat & 1) != 0) {
            this.tokens.add(new SourceToken((SimpleNode)new Name("__file__", 1, false), "__file__", "", "", moduleName, nature, module));
            this.tokens.add(new SourceToken((SimpleNode)new Name("__name__", 1, false), "__name__", "", "", moduleName, nature, module));
        }
    }

    @Override
    protected SourceToken addToken(SimpleNode node) {
        SourceToken tok = super.addToken(node);
        if (tok.getArgs().length() > 0) {
            this.repToTokenWithArgs.put(tok.getRepresentation(), tok);
        }
        return tok;
    }

    protected Object unhandled_node(SimpleNode node) throws Exception {
        return null;
    }

    public void traverse(SimpleNode node) throws Exception {
        node.traverse((VisitorIF)this);
    }

    public Object visitClassDef(ClassDef node) throws Exception {
        if ((this.visitWhat & 1) != 0) {
            this.addToken((SimpleNode)node);
        }
        return null;
    }

    public Object visitFunctionDef(FunctionDef node) throws Exception {
        if ((this.visitWhat & 1) != 0) {
            this.addToken((SimpleNode)node);
        }
        return null;
    }

    public Object visitAssign(Assign node) throws Exception {
        this.lastAssign.push((Object)node);
        node.traverse((VisitorIF)this);
        this.lastAssign.pop();
        return null;
    }

    public Object visitCall(Call node) throws Exception {
        this.lastCall.push((Object)node);
        node.traverse((VisitorIF)this);
        this.lastCall.pop();
        return null;
    }

    public Object visitTypeAlias(TypeAlias node) throws Exception {
        SourceToken token = this.addToken((SimpleNode)node.name);
        token.setFoundInTypeAlias(node);
        return null;
    }

    public Object visitName(Name node) throws Exception {
        if ((this.visitWhat & 1) != 0) {
            if (node.ctx == 2) {
                SourceToken added = this.addToken((SimpleNode)node);
                if (this.lastCall.size() > 0) {
                    added.setFoundInCall((Call)this.lastCall.peek());
                }
                if (this.lastAssign.size() > 0) {
                    SourceToken methodTok;
                    String rep;
                    Assign last = (Assign)this.lastAssign.peek();
                    added.setFoundInAssign(last);
                    if (added.getRepresentation().equals("__all__") && this.__all__Assign == null) {
                        this.__all__ = added;
                        this.__all__Assign = last;
                        this.__all__AssignTargets = last.targets;
                    } else if (last.value != null && !(last.value instanceof Call) && (rep = NodeUtils.getRepresentationString((ISimpleNode)last.value)) != null && (methodTok = this.repToTokenWithArgs.get(rep)) != null) {
                        added.updateAliasToken(methodTok);
                    }
                }
            } else if (node.ctx == 1 && node.id.equals("__all__")) {
                this.__all__AssignTargets = null;
            }
        }
        return null;
    }

    public Object visitImportFrom(ImportFrom node) throws Exception {
        if ((this.visitWhat & 2) != 0) {
            GlobalModelVisitor.makeWildImportToken(node, this.tokens, this.moduleName, this.nature, this.module);
        }
        if ((this.visitWhat & 4) != 0) {
            GlobalModelVisitor.makeImportToken(node, (List<IToken>)this.tokens, this.moduleName, true, this.nature, this.module);
        }
        return null;
    }

    public Object visitImport(Import node) throws Exception {
        if ((this.visitWhat & 4) != 0) {
            GlobalModelVisitor.makeImportToken(node, (List<IToken>)this.tokens, this.moduleName, true, this.nature, this.module);
        }
        return null;
    }

    public Object visitStr(Str node) throws Exception {
        if ((this.visitWhat & 8) != 0) {
            this.tokens.add(new SourceToken((SimpleNode)node, node.s, "", "", this.moduleName, this.nature, this.module));
        }
        return null;
    }

    @Override
    protected void finishVisit() {
        if (this.onlyAllowTokensIn__all__) {
            this.filterAll(this.tokens);
        }
    }

    public void filterAll(List<IToken> tokens) {
        if (this.__all__ != null) {
            SimpleNode ast = this.__all__.getAst();
            if (this.__all__AssignTargets != null && this.__all__AssignTargets.length == 1 && this.__all__AssignTargets[0] == ast) {
                int i;
                HashSet<String> validTokensInAll = new HashSet<String>();
                exprType value = this.__all__Assign.value;
                exprType[] elts = null;
                if (value instanceof org.python.pydev.parser.jython.ast.List) {
                    valueList = (org.python.pydev.parser.jython.ast.List)value;
                    if (valueList.elts != null) {
                        elts = valueList.elts;
                    }
                } else if (value instanceof Tuple) {
                    valueList = (Tuple)value;
                    if (valueList.elts != null) {
                        elts = valueList.elts;
                    }
                }
                if (elts != null) {
                    int len = elts.length;
                    i = 0;
                    while (i < len) {
                        exprType elt = elts[i];
                        if (elt instanceof Str) {
                            Str str = (Str)elt;
                            validTokensInAll.add(str.s);
                        }
                        ++i;
                    }
                }
                if (validTokensInAll.size() > 0) {
                    int len = tokens.size();
                    i = 0;
                    while (i < len) {
                        IToken tok = tokens.get(i);
                        if (!validTokensInAll.contains(tok.getRepresentation())) {
                            tokens.remove(i);
                            --i;
                            --len;
                        }
                        ++i;
                    }
                }
            }
        }
    }
}

