/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.ast.codecompletion.revisited.visitors;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.python.pydev.ast.codecompletion.revisited.modules.SourceToken;
import org.python.pydev.ast.codecompletion.revisited.visitors.GlobalModelVisitor;
import org.python.pydev.core.ILocalScope;
import org.python.pydev.core.IModule;
import org.python.pydev.core.IPythonNature;
import org.python.pydev.core.IToken;
import org.python.pydev.core.ITypeInfo;
import org.python.pydev.core.TokensList;
import org.python.pydev.core.log.Log;
import org.python.pydev.parser.jython.SimpleNode;
import org.python.pydev.parser.jython.ast.Assert;
import org.python.pydev.parser.jython.ast.Assign;
import org.python.pydev.parser.jython.ast.Attribute;
import org.python.pydev.parser.jython.ast.Call;
import org.python.pydev.parser.jython.ast.ClassDef;
import org.python.pydev.parser.jython.ast.Expr;
import org.python.pydev.parser.jython.ast.FunctionDef;
import org.python.pydev.parser.jython.ast.Module;
import org.python.pydev.parser.jython.ast.Name;
import org.python.pydev.parser.jython.ast.Str;
import org.python.pydev.parser.jython.ast.TryExcept;
import org.python.pydev.parser.jython.ast.Tuple;
import org.python.pydev.parser.jython.ast.VisitorIF;
import org.python.pydev.parser.jython.ast.argumentsType;
import org.python.pydev.parser.jython.ast.commentType;
import org.python.pydev.parser.jython.ast.excepthandlerType;
import org.python.pydev.parser.jython.ast.exprType;
import org.python.pydev.parser.jython.ast.stmtType;
import org.python.pydev.parser.visitors.NodeUtils;
import org.python.pydev.parser.visitors.TypeInfo;
import org.python.pydev.parser.visitors.scope.ASTEntry;
import org.python.pydev.parser.visitors.scope.SequencialASTIteratorVisitor;
import org.python.pydev.shared_core.model.ISimpleNode;
import org.python.pydev.shared_core.string.FastStringBuffer;
import org.python.pydev.shared_core.string.FullRepIterable;
import org.python.pydev.shared_core.structure.FastStack;

public class LocalScope
implements ILocalScope {
    public FastStack<ISimpleNode> scope = new FastStack(20);
    public int scopeEndLine = -1;
    public int ifMainLine = -1;
    public SimpleNode foundAtASTNode;
    private final IPythonNature nature;
    public final IModule module;
    public static final Map<String, Integer> ISINSTANCE_POSSIBILITIES = new HashMap<String, Integer>();

    static {
        ISINSTANCE_POSSIBILITIES.put("isinstance".toLowerCase(), 2);
        ISINSTANCE_POSSIBILITIES.put("IsImplementation".toLowerCase(), 2);
        ISINSTANCE_POSSIBILITIES.put("IsInterfaceDeclared".toLowerCase(), 2);
        ISINSTANCE_POSSIBILITIES.put("implementedBy".toLowerCase(), -1);
    }

    public void setFoundAtASTNode(ISimpleNode node) {
        this.foundAtASTNode = (SimpleNode)node;
    }

    public SimpleNode getFoundAtASTNode() {
        return this.foundAtASTNode;
    }

    public LocalScope(IPythonNature nature, IModule module) {
        this.nature = nature;
        this.module = module;
    }

    public LocalScope(IPythonNature nature, FastStack<SimpleNode> scope, IModule module) {
        this.nature = nature;
        this.scope.addAll(scope);
        this.module = module;
    }

    public FastStack<ISimpleNode> getScopeStack() {
        return this.scope;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof LocalScope)) {
            return false;
        }
        LocalScope s = (LocalScope)obj;
        if (this.scope.size() != s.scope.size()) {
            return false;
        }
        return this.checkIfScopesMatch(s);
    }

    public String toString() {
        FastStringBuffer buf = new FastStringBuffer("LocalScope(", 40);
        boolean added = false;
        for (ISimpleNode n : this.scope) {
            if (!added) {
                added = true;
            } else {
                buf.append(", ");
            }
            buf.append(FullRepIterable.getLastPart((String)n.getClass().getName()));
            String rep = NodeUtils.getRepresentationString((ISimpleNode)n);
            if (rep == null) continue;
            buf.append('(');
            buf.append(rep);
            buf.append(')');
        }
        buf.append(')');
        return buf.toString();
    }

    public int hashCode() {
        int hash = 43;
        for (SimpleNode element : this.scope) {
            hash += Integer.hashCode(element.beginColumn);
            hash += Integer.hashCode(element.beginLine);
            hash += element.getClass().hashCode();
            String rep1 = NodeUtils.getFullRepresentationString((SimpleNode)element);
            if (rep1 == null) continue;
            hash += rep1.hashCode();
        }
        return hash;
    }

    public boolean isOuterOrSameScope(ILocalScope s) {
        if (this.scope.size() > s.getScopeStack().size()) {
            return false;
        }
        return this.checkIfScopesMatch(s);
    }

    private boolean checkIfScopesMatch(ILocalScope s) {
        ListIterator otIt = s.getScopeStack().iterator();
        for (SimpleNode element : this.scope) {
            SimpleNode otElement = (SimpleNode)otIt.next();
            if (element.beginColumn != otElement.beginColumn) {
                return false;
            }
            if (element.beginLine != otElement.beginLine) {
                return false;
            }
            if (!element.getClass().equals(otElement.getClass())) {
                return false;
            }
            String rep1 = NodeUtils.getFullRepresentationString((SimpleNode)element);
            String rep2 = NodeUtils.getFullRepresentationString((SimpleNode)otElement);
            if (!(rep1 == null || rep2 == null ? rep1 != rep2 : !rep1.equals(rep2))) continue;
            return false;
        }
        return true;
    }

    public TokensList getAllLocalTokens() {
        return this.getLocalTokens(Integer.MAX_VALUE, Integer.MAX_VALUE, false);
    }

    public TokensList getLocalTokens(int line, int col, boolean onlyArgs) {
        HashSet<SourceToken> comps = new HashSet<SourceToken>();
        ListIterator iter = this.scope.iterator();
        while (iter.hasNext()) {
            SimpleNode element = (SimpleNode)iter.next();
            stmtType[] body = null;
            if (element instanceof FunctionDef) {
                String s;
                FunctionDef f = (FunctionDef)element;
                argumentsType args = f.args;
                int i = 0;
                while (i < args.args.length) {
                    s = NodeUtils.getRepresentationString((ISimpleNode)args.args[i]);
                    SourceToken sourceToken = new SourceToken((SimpleNode)args.args[i], s, "", "", "", 5, this.nature, this.module);
                    if (args.annotation != null && args.annotation.length > i && args.annotation[i] != null) {
                        targets = new exprType[]{args.args[i]};
                        value = null;
                        if (args.defaults != null && args.defaults.length > i && args.defaults[i] != null) {
                            value = args.defaults[i];
                        }
                        exprType type = args.annotation[i];
                        sourceToken.setDummyAssignFromParam(new Assign(targets, value, type));
                    } else if (args.defaults != null && args.defaults.length > i && args.defaults[i] != null) {
                        targets = new exprType[]{args.args[i]};
                        value = args.defaults[i];
                        sourceToken.setDummyAssignFromParam(new Assign(targets, value, null));
                    }
                    comps.add(sourceToken);
                    ++i;
                }
                if (args.vararg != null) {
                    String s2 = NodeUtils.getRepresentationString((ISimpleNode)args.vararg);
                    comps.add(new SourceToken((SimpleNode)args.vararg, s2, "", "", "", 5, this.nature, this.module));
                }
                if (args.kwarg != null) {
                    String s3 = NodeUtils.getRepresentationString((ISimpleNode)args.kwarg);
                    comps.add(new SourceToken((SimpleNode)args.kwarg, s3, "", "", "", 5, this.nature, this.module));
                }
                if (args.kwonlyargs != null) {
                    i = 0;
                    while (i < args.kwonlyargs.length) {
                        s = NodeUtils.getRepresentationString((ISimpleNode)args.kwonlyargs[i]);
                        comps.add(new SourceToken((SimpleNode)args.kwonlyargs[i], s, "", "", "", 5, this.nature, this.module));
                        ++i;
                    }
                }
                body = f.body;
            } else if (element instanceof ClassDef && !iter.hasNext()) {
                ClassDef classDef = (ClassDef)element;
                body = classDef.body;
            }
            if (onlyArgs || body == null) continue;
            try {
                int i = 0;
                while (i < body.length) {
                    GlobalModelVisitor visitor = new GlobalModelVisitor(1, "", false, true, this.nature, this.module);
                    stmtType stmt = body[i];
                    if (stmt != null) {
                        stmt.accept((VisitorIF)visitor);
                        List t = visitor.tokens;
                        for (SourceToken tok : t) {
                            tok.type = 9;
                            if (tok.getAst().beginLine > line) continue;
                            comps.add(tok);
                        }
                    }
                    ++i;
                }
            }
            catch (Exception e) {
                Log.log((Throwable)e);
            }
        }
        return new TokensList((IToken[])comps.toArray(new SourceToken[0]));
    }

    public TokensList getInterfaceForLocal(String activationToken) {
        return this.getInterfaceForLocal(activationToken, true, true);
    }

    public TokensList getInterfaceForLocal(String activationToken, boolean addAttributeAccess, boolean addLocalsFromHasAttr) {
        HashSet<SourceToken> comps = new HashSet<SourceToken>();
        Iterator it = this.scope.topDownIterator();
        if (!it.hasNext()) {
            return new TokensList();
        }
        SimpleNode element = (SimpleNode)it.next();
        String dottedActTok = activationToken + ".";
        SequencialASTIteratorVisitor visitor = SequencialASTIteratorVisitor.create((SimpleNode)element, (boolean)false);
        ArrayList<Class> classes = new ArrayList<Class>(2);
        if (addAttributeAccess) {
            classes.add(Attribute.class);
        }
        if (addLocalsFromHasAttr) {
            classes.add(Call.class);
        }
        Iterator iterator = visitor.getIterator(classes.toArray(new Class[classes.size()]));
        while (iterator.hasNext()) {
            exprType node;
            String rep;
            ASTEntry entry = (ASTEntry)iterator.next();
            if (entry.node instanceof Attribute) {
                String rep2 = NodeUtils.getFullRepresentationString((SimpleNode)entry.node);
                if (!rep2.startsWith(dottedActTok) || !NodeUtils.isValidNameRepresentation((String)(rep2 = rep2.substring(dottedActTok.length())))) continue;
                comps.add(new SourceToken(entry.node, FullRepIterable.getFirstPart((String)rep2), "", "", "", 10, this.nature, this.module));
                continue;
            }
            if (!(entry.node instanceof Call)) continue;
            Call call = (Call)entry.node;
            if (!"hasattr".equals(NodeUtils.getFullRepresentationString((SimpleNode)call.func)) || call.args == null || call.args.length != 2 || !(rep = NodeUtils.getFullRepresentationString((SimpleNode)call.args[0])).equals(activationToken) || !((node = call.args[1]) instanceof Str)) continue;
            Str str = (Str)node;
            String attrName = str.s;
            if (!NodeUtils.isValidNameRepresentation((String)attrName)) continue;
            comps.add(new SourceToken((SimpleNode)node, attrName, "", "", "", 10, this.nature, this.module));
        }
        return new TokensList(comps.toArray(new IToken[0]));
    }

    public TokensList getLocalImportedModules(int line, int col, String moduleName) {
        ArrayList<IToken> importedModules = new ArrayList<IToken>();
        for (SimpleNode element : this.scope) {
            if (!(element instanceof FunctionDef)) continue;
            FunctionDef f = (FunctionDef)element;
            if (f.body == null) continue;
            int i = 0;
            while (i < f.body.length) {
                stmtType stmt = f.body[i];
                if (stmt != null) {
                    importedModules.addAll(GlobalModelVisitor.getTokens((SimpleNode)stmt, 4, moduleName, null, false, this.nature, this.module));
                }
                ++i;
            }
        }
        return new TokensList(importedModules);
    }

    public ClassDef getClassDef() {
        Iterator it = this.scope.topDownIterator();
        while (it.hasNext()) {
            SimpleNode node = (SimpleNode)it.next();
            if (!(node instanceof ClassDef)) continue;
            return (ClassDef)node;
        }
        return null;
    }

    public boolean isLastClassDef() {
        return this.scope.size() > 0 && this.scope.peek() instanceof ClassDef;
    }

    public Iterator<ISimpleNode> iterator() {
        return this.scope.topDownIterator();
    }

    public int getIfMainLine() {
        return this.ifMainLine;
    }

    public int getScopeEndLine() {
        return this.scopeEndLine;
    }

    public void setIfMainLine(int original) {
        this.ifMainLine = original;
    }

    public void setScopeEndLine(int beginLine) {
        this.scopeEndLine = beginLine;
    }

    public List<ITypeInfo> getPossibleClassesForActivationToken(String actTok) {
        ArrayList<ITypeInfo> ret = new ArrayList<ITypeInfo>();
        Iterator it = this.scope.topDownIterator();
        if (!it.hasNext()) {
            return ret;
        }
        SimpleNode element = (SimpleNode)it.next();
        TypeInfo typeForParameter = NodeUtils.getTypeForParameterFromAST((String)actTok, (SimpleNode)element);
        if (typeForParameter != null) {
            ret.add((ITypeInfo)typeForParameter);
        }
        SequencialASTIteratorVisitor visitor = SequencialASTIteratorVisitor.create((SimpleNode)element, (boolean)false);
        Iterator iterator = visitor.getIterator();
        ArrayList<SimpleNode> lst = new ArrayList<SimpleNode>();
        Name nameDefinition = null;
        while (iterator.hasNext()) {
            Attribute attribute;
            int n;
            ASTEntry entry = (ASTEntry)iterator.next();
            if (entry.node.specialsAfter != null) {
                lst.addAll(entry.node.specialsAfter);
            }
            if (entry.node.specialsBefore != null) {
                lst.addAll(entry.node.specialsBefore);
            }
            if (entry.node instanceof TryExcept) {
                excepthandlerType[] handlers = ((TryExcept)entry.node).handlers;
                if (handlers == null) continue;
                excepthandlerType[] excepthandlerTypeArray = handlers;
                int n2 = handlers.length;
                int n3 = 0;
                while (n3 < n2) {
                    excepthandlerType handle = excepthandlerTypeArray[n3];
                    if (handle.name != null && actTok.equals(NodeUtils.getFullRepresentationString((SimpleNode)handle.name))) {
                        if (handle.type instanceof Tuple) {
                            exprType[] tupElts = ((Tuple)handle.type).elts;
                            if (tupElts != null) {
                                exprType[] exprTypeArray = tupElts;
                                n = tupElts.length;
                                int n4 = 0;
                                while (n4 < n) {
                                    exprType type = exprTypeArray[n4];
                                    if (type != null) {
                                        ret.add((ITypeInfo)new TypeInfo(NodeUtils.getFullRepresentationString((SimpleNode)type)));
                                    }
                                    ++n4;
                                }
                            }
                        } else if (handle.type != null) {
                            ret.add((ITypeInfo)new TypeInfo(NodeUtils.getFullRepresentationString((SimpleNode)handle.type)));
                        }
                    }
                    ++n3;
                }
                continue;
            }
            if (entry.node instanceof Assert) {
                String foundActTok;
                Integer classIndex;
                Assert assrt = (Assert)entry.node;
                if (!(assrt.test instanceof Call)) continue;
                Call call = (Call)assrt.test;
                String rep = NodeUtils.getFullRepresentationString((SimpleNode)call.func);
                if (rep == null || (classIndex = ISINSTANCE_POSSIBILITIES.get(FullRepIterable.getLastPart((String)rep).toLowerCase())) == null || call.args == null || call.args.length < Math.max(classIndex, 1) || (foundActTok = NodeUtils.getFullRepresentationString((SimpleNode)call.args[0])) == null || !foundActTok.equals(actTok)) continue;
                if (classIndex > 0) {
                    exprType type = call.args[classIndex - 1];
                    if (type instanceof Tuple) {
                        Tuple tuple = (Tuple)type;
                        exprType[] exprTypeArray = tuple.elts;
                        int n5 = tuple.elts.length;
                        n = 0;
                        while (n < n5) {
                            exprType expr = exprTypeArray[n];
                            this.addRepresentationIfPossible(ret, expr);
                            ++n;
                        }
                        continue;
                    }
                    this.addRepresentationIfPossible(ret, type);
                    continue;
                }
                ret.add((ITypeInfo)new TypeInfo(FullRepIterable.getWithoutLastPart((String)rep)));
                continue;
            }
            if (entry.node instanceof Call && this.isTypingCast((Call)entry.node)) {
                Call call = (Call)entry.node;
                if (call.args == null || call.args.length <= 0) continue;
                exprType type = call.args[0];
                this.addRepresentationIfPossible(ret, type);
                continue;
            }
            if (entry.node instanceof Str) {
                lst.add(entry.node);
            }
            if (entry.node instanceof Name) {
                Name name = (Name)entry.node;
                if (name.ctx == 1 && actTok.equals(name.id)) {
                    nameDefinition = name;
                }
            }
            if (!(entry.node instanceof Expr)) continue;
            Expr expr = (Expr)entry.node;
            if (!(expr.value instanceof Attribute) || !actTok.equals(NodeUtils.getFullRepresentationString((SimpleNode)(attribute = (Attribute)expr.value)))) continue;
            nameDefinition = attribute;
        }
        if (nameDefinition != null) {
            int s = lst.size();
            int i = 0;
            while (i < s) {
                Object object = lst.get(i);
                if (object instanceof commentType) {
                    commentType commentType2 = (commentType)object;
                    if (commentType2.id != null) {
                        String trim = commentType2.id.trim();
                        if (trim.startsWith("#")) {
                            trim = trim.substring(1).trim();
                        }
                        if (trim.startsWith(":")) {
                            type = NodeUtils.getTypeForParameterFromDocstring((String)actTok, (String)trim.substring(1));
                            if (type != null) {
                                ret.add((ITypeInfo)new TypeInfo(type));
                            }
                        } else if (trim.startsWith("@") && (type = NodeUtils.getTypeForParameterFromDocstring((String)actTok, (String)trim)) != null) {
                            ret.add((ITypeInfo)new TypeInfo(type));
                        }
                    }
                } else if (object instanceof Str) {
                    Str str = (Str)object;
                    if (str.s != null) {
                        String trim = str.s.trim();
                        if (trim.startsWith("#")) {
                            trim = trim.substring(1).trim();
                        }
                        if (trim.startsWith(":")) {
                            type = NodeUtils.getTypeForParameterFromDocstring((String)actTok, (String)trim.substring(1));
                            if (type != null) {
                                ret.add((ITypeInfo)new TypeInfo(type));
                            }
                        } else if (trim.startsWith("@") && (type = NodeUtils.getTypeForParameterFromDocstring((String)actTok, (String)trim)) != null) {
                            ret.add((ITypeInfo)new TypeInfo(type));
                        }
                    }
                }
                ++i;
            }
        }
        return ret;
    }

    private boolean isTypingCast(Call call) {
        if (call.func != null) {
            String callFuncRep = NodeUtils.getFullRepresentationString((SimpleNode)call.func);
            return "typing.cast".equals(callFuncRep);
        }
        return false;
    }

    private void addRepresentationIfPossible(List<ITypeInfo> ret, exprType expr) {
        String string;
        if ((expr instanceof Name || expr instanceof Attribute) && (string = NodeUtils.getFullRepresentationString((SimpleNode)expr)) != null) {
            ret.add((ITypeInfo)new TypeInfo(string));
        }
    }

    public IPythonNature getPythonNature() {
        return this.nature;
    }

    public String getScopeStackPathNames() {
        ListIterator iterator = this.scope.iterator();
        return this.nodesIteratorToPathName(iterator);
    }

    private String nodesIteratorToPathName(Iterator<ISimpleNode> iterator) {
        String rep;
        SimpleNode next;
        FastStringBuffer buf = new FastStringBuffer();
        if (iterator.hasNext() && !((next = (SimpleNode)iterator.next()) instanceof Module) && (rep = NodeUtils.getRepresentationString((ISimpleNode)next)) != null && rep.length() > 0) {
            buf.append(rep);
        }
        while (iterator.hasNext()) {
            next = (SimpleNode)iterator.next();
            rep = NodeUtils.getRepresentationString((ISimpleNode)next);
            if (rep != null && rep.length() > 0) {
                if (!buf.isEmpty()) {
                    buf.append('.');
                }
                buf.append(rep);
                continue;
            }
            return "";
        }
        return buf.toString();
    }

    public String getScopeStackPathNamesToLastClassDef() {
        ArrayList<SimpleNode> arrayList = new ArrayList<SimpleNode>();
        boolean found = false;
        for (SimpleNode node : this.scope) {
            arrayList.add(node);
            if (!(node instanceof ClassDef)) continue;
            found = true;
            break;
        }
        if (!found) {
            return "";
        }
        return this.nodesIteratorToPathName(arrayList.iterator());
    }
}

