/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.ast.codecompletion.shell;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.nio.channels.ServerSocketChannel;
import java.nio.charset.StandardCharsets;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.python.copiedfromeclipsesrc.JDTNotAvailableException;
import org.python.pydev.ast.codecompletion.PyCodeCompletionPreferences;
import org.python.pydev.ast.codecompletion.shell.ProcessCreationInfo;
import org.python.pydev.ast.codecompletion.shell.ShellsContainer;
import org.python.pydev.core.IInterpreterInfo;
import org.python.pydev.core.IPythonNature;
import org.python.pydev.core.MisconfigurationException;
import org.python.pydev.core.PythonNatureWithoutProjectException;
import org.python.pydev.core.ShellId;
import org.python.pydev.core.concurrency.Semaphore;
import org.python.pydev.core.log.Log;
import org.python.pydev.core.logging.DebugSettings;
import org.python.pydev.core.proposals.CompletionProposalFactory;
import org.python.pydev.shared_core.SharedCorePlugin;
import org.python.pydev.shared_core.io.FileUtils;
import org.python.pydev.shared_core.io.HttpProtocolUtils;
import org.python.pydev.shared_core.log.ToLogFile;
import org.python.pydev.shared_core.net.SocketUtil;
import org.python.pydev.shared_core.string.FastStringBuffer;
import org.python.pydev.shared_core.string.StringUtils;
import org.python.pydev.shared_core.utils.Timer;

public abstract class AbstractShell {
    public static final int BUFFER_SIZE = 20480;
    protected static final int DEFAULT_SLEEP_BETWEEN_ATTEMPTS = 1000;
    protected static final int DEBUG_SHELL = -1;
    private volatile boolean inStart = false;
    private volatile boolean isConnected = false;
    private volatile boolean isInRead = false;
    private volatile boolean isInWrite = false;
    private volatile boolean isInRestart = false;
    private IInterpreterInfo shellInterpreter;
    private final Semaphore semaphore = new Semaphore(1L);
    private final Object ioLock = new Object();
    protected final Object lockLastPythonPath = new Object();
    protected String lastPythonPath = null;
    static final String ENCODING_UTF_8 = "UTF-8";
    static volatile boolean finishedForGood = false;
    protected ProcessCreationInfo process;
    private Socket socket;
    protected File serverFile;
    private ServerSocket serverSocket;
    private ServerSocketChannel serverSocketChannel;
    private final Object waitLock = new Object();
    private final HttpProtocolUtils httpProtocol = new HttpProtocolUtils();

    public static ShellId[] getAllShellIds() {
        return ShellId.values();
    }

    public static ShellId getShellId() {
        return CompletionProposalFactory.get().getShellId();
    }

    private static void dbg(String string, int priority) {
        if (priority <= -1) {
            System.out.println(string);
        }
        if (DebugSettings.DEBUG_CODE_COMPLETION) {
            ToLogFile.toLogFile((String)string, AbstractShell.class);
        }
    }

    protected AbstractShell(File scriptWithinPySrc) throws IOException, CoreException {
        if (finishedForGood) {
            throw new RuntimeException("Shells are already finished for good, so, it is an invalid state to try to create a new shell.");
        }
        this.serverFile = scriptWithinPySrc;
        if (!FileUtils.enhancedIsFile((File)this.serverFile)) {
            throw new RuntimeException("Can't find python server file");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sleepALittle(int t) {
        try {
            Object object = this.waitLock;
            synchronized (object) {
                this.waitLock.wait(t);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static void stopServerShell(IInterpreterInfo interpreter, ShellId id) {
        ShellsContainer.stopServerShell(interpreter, id);
    }

    public static void shutdownAllShells() {
        ShellsContainer.shutdownAllShells();
    }

    public static String restartAllShells() {
        return ShellsContainer.restartAllShells();
    }

    public static void putServerShell(IPythonNature nature, ShellId id, AbstractShell shell) {
        ShellsContainer.putServerShell(nature, id, shell);
    }

    public static AbstractShell getServerShell(IPythonNature nature, ShellId id) throws IOException, JDTNotAvailableException, CoreException, MisconfigurationException, PythonNatureWithoutProjectException {
        return ShellsContainer.getServerShell(nature, id);
    }

    public void startIt(IPythonNature nature) throws IOException, JDTNotAvailableException, CoreException, MisconfigurationException, PythonNatureWithoutProjectException {
        this.startIt(nature.getProjectInterpreter());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void startIt(IInterpreterInfo interpreter) throws IOException, JDTNotAvailableException, CoreException, MisconfigurationException {
        milisSleep = 1000;
        var3_3 = this.ioLock;
        synchronized (var3_3) {
            block27: {
                this.shellInterpreter = interpreter;
                if (this.inStart || this.isConnected) {
                    return;
                }
                this.inStart = true;
                try {
                    if (AbstractShell.finishedForGood) {
                        throw new RuntimeException("Shells are already finished for good, so, it is an invalid state to try to restart it.");
                    }
                    try {
                        this.serverSocketChannel = ServerSocketChannel.open();
                        this.serverSocketChannel.configureBlocking(false);
                        this.serverSocketChannel.bind(new InetSocketAddress(0));
                        this.serverSocket = this.serverSocketChannel.socket();
                        port = this.serverSocket.getLocalPort();
                        SocketUtil.checkValidPort((int)port);
                        if (this.process != null) {
                            this.endIt();
                        }
                        this.process = this.createServerProcess(interpreter, port);
                        AbstractShell.dbg("executed: " + this.process.getProcessLog(), 1);
                        this.sleepALittle(200);
                        try {
                            exitVal = this.process.exitValue();
                            msg = "Error creating python process - exited before creating sockets - exitValue = (" + exitVal + ").\n" + this.process.getProcessLog();
                            AbstractShell.dbg(msg, 1);
                            Log.log((String)msg);
                            throw new CoreException((IStatus)SharedCorePlugin.makeStatus((int)4, (String)msg, (Throwable)new Exception(msg)));
                        }
                        catch (IllegalThreadStateException exitVal) {
                            AbstractShell.dbg("afterCreateProcess ", 1);
                            connected = false;
                            attempt = 0;
                            AbstractShell.dbg("connecting... ", 1);
                            this.sleepALittle(milisSleep);
                            maxAttempts = PyCodeCompletionPreferences.getNumberOfConnectionAttempts();
                            AbstractShell.dbg("maxAttempts: " + maxAttempts, 1);
                            AbstractShell.dbg("finishedForGood: " + AbstractShell.finishedForGood, 1);
                            ** while (!connected && attempt < maxAttempts && !AbstractShell.finishedForGood)
                        }
lbl-1000:
                        // 1 sources

                        {
                            block26: {
                                AbstractShell.dbg("connecting attept..." + ++attempt, 1);
                                try {
                                    try {
                                        AbstractShell.dbg("serverSocket.accept()! ", 1);
                                        initial = System.currentTimeMillis();
                                        accept = null;
                                        while (accept == null && System.currentTimeMillis() - initial < 5000L) {
                                            AbstractShell.dbg("serverSocketChannel.accept(): waiting for python client to connect back to the eclipse java vm", 1);
                                            accept = this.serverSocketChannel.accept();
                                            if (accept != null) continue;
                                            this.sleepALittle(500);
                                        }
                                        if (accept != null) {
                                            this.socket = accept.socket();
                                            AbstractShell.dbg("socketToRead.setSoTimeout(8000) ", 1);
                                            this.socket.setSoTimeout(8000);
                                            connected = true;
                                            AbstractShell.dbg("connected! ", 1);
                                            break block26;
                                        }
                                        msg = "The python client still hasn't connected back to the eclipse java vm (will retry...)";
                                        AbstractShell.dbg(msg, 1);
                                        Log.log((String)msg);
                                    }
                                    catch (SocketTimeoutException e) {
                                        AbstractShell.dbg("SocketTimeoutException! ", 1);
                                    }
                                }
                                catch (IOException e1) {
                                    AbstractShell.dbg("IOException! ", 1);
                                }
                            }
                            if (connected || attempt <= 1) continue;
                            msg = "Attempt: " + attempt + " of " + maxAttempts + " failed, trying again...(socket connected: " + String.valueOf(this.socket == null ? "still null" : Boolean.valueOf(this.socket.isConnected())) + ")";
                            AbstractShell.dbg(msg, 1);
                            Log.log((String)msg);
                            this.sleepALittle(milisSleep);
                            continue;
                        }
lbl80:
                        // 1 sources

                        if (connected || AbstractShell.finishedForGood) break block27;
                        AbstractShell.dbg("NOT connected ", 1);
                        try {
                            exitVal = this.process.exitValue();
                            isAlive = " - the process in NOT ALIVE anymore (output=" + exitVal + ") - ";
                        }
                        catch (IllegalThreadStateException e2) {
                            isAlive = " - the process in still alive (killing it now)- ";
                            this.process.destroy();
                        }
                        this.closeConn();
                        msg = "Error connecting to python process (most likely cause for failure is a firewall blocking communication or a misconfigured network).\n" + (String)isAlive + "\n" + this.process.getProcessLog();
                        exception = new RuntimeException(msg);
                        AbstractShell.dbg(msg, 1);
                        Log.log((Throwable)exception);
                        throw exception;
                    }
                    catch (IOException e) {
                        if (this.process != null) {
                            this.process.destroy();
                            this.process = null;
                        }
                        throw e;
                    }
                }
                finally {
                    this.inStart = false;
                }
            }
            this.isConnected = true;
        }
        var3_3 = this.lockLastPythonPath;
        synchronized (var3_3) {
            this.lastPythonPath = null;
        }
    }

    protected abstract ProcessCreationInfo createServerProcess(IInterpreterInfo var1, int var2) throws IOException, JDTNotAvailableException, MisconfigurationException;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private FastStringBuffer read(boolean useContentLen, IProgressMonitor monitor) throws IOException {
        Object object = this.ioLock;
        synchronized (object) {
            if (finishedForGood) {
                throw new RuntimeException("Shells are already finished for good, so, it is an invalid state to try to read from it.");
            }
            if (this.inStart) {
                throw new RuntimeException("The shell is still not completely started, so, it is an invalid state to try to read from it.");
            }
            if (!this.isConnected) {
                throw new RuntimeException("The shell is still not connected, so, it is an invalid state to try to read from it.");
            }
            if (this.isInRead) {
                throw new RuntimeException("The shell is already in read mode, so, it is an invalid state to try to read from it.");
            }
            if (this.isInWrite) {
                throw new RuntimeException("The shell is already in write mode, so, it is an invalid state to try to read from it.");
            }
            this.isInRead = true;
            try {
                block21: {
                    FastStringBuffer fastStringBuffer;
                    int len;
                    if (useContentLen) {
                        String read = this.readWithContentLen(this.socket.getInputStream());
                        FastStringBuffer fastStringBuffer2 = new FastStringBuffer(read, 0);
                        return fastStringBuffer2;
                    }
                    FastStringBuffer strBuf = new FastStringBuffer(20480);
                    byte[] b = new byte[20480];
                    int searchFrom = 0;
                    while ((len = this.socket.getInputStream().read(b)) > 0) {
                        String s = new String(b, 0, len);
                        searchFrom = strBuf.length() - 5;
                        if (searchFrom < 0) {
                            searchFrom = 0;
                        }
                        strBuf.append(s);
                        if (strBuf.indexOf("END@@", searchFrom) != -1) break;
                        this.sleepALittle(10);
                    }
                    strBuf.replaceFirst("@@COMPLETIONS", "");
                    if ((searchFrom -= "@@COMPLETIONS".length()) < 0) {
                        searchFrom = 0;
                    }
                    try {
                        int endIndex = strBuf.indexOf("END@@", searchFrom);
                        if (endIndex == -1) break block21;
                        strBuf.setCount(endIndex);
                        fastStringBuffer = strBuf;
                    }
                    catch (RuntimeException e) {
                        if (strBuf.length() > 500) {
                            strBuf.setCount(499).append("...(continued)...");
                        }
                        Log.log((int)4, (String)("ERROR WITH STRING:" + String.valueOf(strBuf)), (Throwable)e);
                        FastStringBuffer fastStringBuffer3 = new FastStringBuffer();
                        return fastStringBuffer3;
                    }
                    return fastStringBuffer;
                }
                throw new RuntimeException("Couldn't find END@@ on received string.");
            }
            finally {
                this.isInRead = false;
            }
        }
    }

    private String readWithContentLen(InputStream in) throws IOException {
        return this.httpProtocol.readContents(in, null);
    }

    private FastStringBuffer read(boolean useContentLen) throws IOException {
        FastStringBuffer r = this.read(useContentLen, null);
        return r;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void write(boolean useContentLen, String str) throws IOException {
        Object object = this.ioLock;
        synchronized (object) {
            if (finishedForGood) {
                throw new RuntimeException("Shells are already finished for good, so, it is an invalid state to try to write to it.");
            }
            if (this.inStart) {
                throw new RuntimeException("The shell is still not completely started, so, it is an invalid state to try to write to it.");
            }
            if (!this.isConnected) {
                throw new RuntimeException("The shell is still not connected, so, it is an invalid state to try to write to it.");
            }
            if (this.isInRead) {
                throw new RuntimeException("The shell is already in read mode, so, it is an invalid state to try to write to it.");
            }
            if (this.isInWrite) {
                throw new RuntimeException("The shell is already in write mode, so, it is an invalid state to try to write to it.");
            }
            this.isInWrite = true;
            try {
                OutputStream outputStream = this.socket.getOutputStream();
                byte[] bytes = str.getBytes(StandardCharsets.UTF_8);
                if (useContentLen) {
                    FastStringBuffer buf = new FastStringBuffer("Content-Length: ", 20).append(bytes.length).append("\r\n\r\n");
                    outputStream.write(buf.getBytes());
                }
                outputStream.write(bytes);
                outputStream.flush();
            }
            finally {
                this.isInWrite = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeConn() throws IOException {
        Object object = this.ioLock;
        synchronized (object) {
            try {
                if (this.socket != null) {
                    this.socket.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.socket = null;
            try {
                if (this.serverSocketChannel != null) {
                    this.serverSocketChannel.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.serverSocketChannel = null;
            try {
                if (this.serverSocket != null) {
                    this.serverSocket.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.serverSocket = null;
        }
        object = this.lockLastPythonPath;
        synchronized (object) {
            this.lastPythonPath = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void shutdown() {
        Object object = this.ioLock;
        synchronized (object) {
            this.socket = null;
            this.serverSocket = null;
            this.serverSocketChannel = null;
            if (this.process != null) {
                this.process.destroy();
                this.process = null;
            }
        }
        object = this.lockLastPythonPath;
        synchronized (object) {
            this.lastPythonPath = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endIt() {
        Object object = this.ioLock;
        synchronized (object) {
            try {
                this.closeConn();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.isConnected = false;
            if (this.process != null) {
                this.process.destroy();
                this.process = null;
            }
        }
        object = this.lockLastPythonPath;
        synchronized (object) {
            this.lastPythonPath = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void restartShell() throws CoreException {
        Object object = this.ioLock;
        synchronized (object) {
            if (!this.isInRestart) {
                this.isInRestart = true;
                try {
                    if (finishedForGood) {
                        throw new RuntimeException("Shells are already finished for good, so, it is an invalid state to try to restart a new shell.");
                    }
                    try {
                        this.endIt();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        this.startIt(this.shellInterpreter);
                    }
                    catch (Exception e) {
                        Log.log((int)4, (String)"ERROR restarting shell.", (Throwable)e);
                    }
                }
                finally {
                    this.isInRestart = false;
                }
            }
        }
    }

    protected AutoCloseable acquire(String msg) {
        final Timer timer = new Timer();
        this.semaphore.acquire();
        final String s = msg;
        return new AutoCloseable(){

            @Override
            public void close() throws Exception {
                AbstractShell.this.semaphore.release();
            }
        };
    }

    protected FastStringBuffer writeAndGetResults(String ... str) throws CoreException {
        return this.writeAndGetResults(false, str);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected FastStringBuffer writeAndGetResults(boolean useContentLen, String ... str) throws CoreException {
        try {
            Object object = this.ioLock;
            synchronized (object) {
                try {
                    FastStringBuffer read;
                    this.write(useContentLen, StringUtils.join((String)"", (String[])str));
                    FastStringBuffer fastStringBuffer = read = this.read(useContentLen);
                    return fastStringBuffer;
                }
                catch (Throwable throwable) {
                    try {
                        throw throwable;
                    }
                    catch (Exception e) {
                        String message = "ERROR reading shell. Message sent: " + StringUtils.join((String)"", (String[])str) + "\n";
                        if (this.process != null) {
                            message = message + "\n" + this.process.getProcessLog();
                        }
                        Log.log((int)4, (String)message, (Throwable)e);
                        this.restartShell();
                        return null;
                    }
                }
            }
        }
        finally {
            if (this.process != null) {
                this.process.clearOutput();
            }
        }
    }
}

