/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.ast.codecompletion.shell;

import java.io.IOException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.python.pydev.ast.codecompletion.shell.AbstractShell;
import org.python.pydev.core.ObjectsInternPool;
import org.python.pydev.core.logging.DebugSettings;
import org.python.pydev.shared_core.log.ToLogFile;
import org.python.pydev.shared_core.string.FastStringBuffer;
import org.python.pydev.shared_core.structure.Tuple;

class ShellConvert {
    private static final String TYPE_UNKNOWN_STR = String.valueOf(-1);
    private static final String ENCODING_UTF_8 = "UTF-8";

    ShellConvert() {
    }

    private static Tuple<String, List<String[]>> getInvalidCompletion() {
        ArrayList l = new ArrayList();
        return new Tuple(null, l);
    }

    static Tuple<String, List<String[]>> convertStringToCompletions(FastStringBuffer read) throws IOException {
        if (read == null) {
            return ShellConvert.getInvalidCompletion();
        }
        ArrayList<String[]> list = new ArrayList<String[]>();
        FastStringBuffer string = read.replaceAll("(", "").replaceAll(")", "");
        StringTokenizer tokenizer = new StringTokenizer(string.toString(), ",");
        string = null;
        ObjectsInternPool.ObjectsPoolMap map = new ObjectsInternPool.ObjectsPoolMap();
        String file = "";
        if (tokenizer.hasMoreTokens()) {
            file = URLDecoder.decode(tokenizer.nextToken(), ENCODING_UTF_8);
            while (tokenizer.hasMoreTokens()) {
                String token = ObjectsInternPool.internLocal((ObjectsInternPool.ObjectsPoolMap)map, (String)URLDecoder.decode(tokenizer.nextToken(), ENCODING_UTF_8));
                if (!tokenizer.hasMoreTokens()) {
                    return new Tuple((Object)file, list);
                }
                String description = ObjectsInternPool.internLocal((ObjectsInternPool.ObjectsPoolMap)map, (String)URLDecoder.decode(tokenizer.nextToken(), ENCODING_UTF_8));
                String args = "";
                if (tokenizer.hasMoreTokens()) {
                    args = ObjectsInternPool.internLocal((ObjectsInternPool.ObjectsPoolMap)map, (String)URLDecoder.decode(tokenizer.nextToken(), ENCODING_UTF_8));
                }
                String type = TYPE_UNKNOWN_STR;
                if (tokenizer.hasMoreTokens()) {
                    type = ObjectsInternPool.internLocal((ObjectsInternPool.ObjectsPoolMap)map, (String)URLDecoder.decode(tokenizer.nextToken(), ENCODING_UTF_8));
                }
                if (!token.equals("ERROR:")) {
                    list.add(new String[]{token, description, args, type});
                    continue;
                }
                if (!DebugSettings.DEBUG_CODE_COMPLETION) continue;
                ToLogFile.addLogLevel();
                try {
                    ToLogFile.toLogFile((String)"Code completion shell error:", AbstractShell.class);
                    ToLogFile.toLogFile((String)token, AbstractShell.class);
                    ToLogFile.toLogFile((String)description, AbstractShell.class);
                    ToLogFile.toLogFile((String)args, AbstractShell.class);
                    ToLogFile.toLogFile((String)type, AbstractShell.class);
                }
                finally {
                    ToLogFile.remLogLevel();
                }
            }
        }
        return new Tuple((Object)file, list);
    }
}

