/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.ast.interpreter_managers;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.python.pydev.core.log.Log;
import org.python.pydev.plugin.nature.PythonNature;
import org.python.pydev.shared_core.SharedCorePlugin;
import org.python.pydev.shared_core.io.FileUtils;

public class DefaultPathsForInterpreterInfo {
    private final Set<IPath> rootPaths;

    public DefaultPathsForInterpreterInfo(boolean resolvingInterpreter) {
        boolean addInterpreterInfoSubstitutions = !resolvingInterpreter;
        this.rootPaths = DefaultPathsForInterpreterInfo.getRootPaths(addInterpreterInfoSubstitutions);
    }

    public boolean selectByDefault(String data) {
        return !DefaultPathsForInterpreterInfo.isChildOfRootPath(data, this.rootPaths);
    }

    public boolean forceDeselect(String data) {
        return DefaultPathsForInterpreterInfo.isRootPath(data, this.rootPaths);
    }

    public static boolean exists(String data) {
        return new File(data).exists();
    }

    public static boolean isChildOfRootPath(String data, Set<IPath> rootPaths) {
        IPath path = Path.fromOSString((String)data);
        java.nio.file.Path nativePath = new File(data).toPath();
        for (IPath p : rootPaths) {
            if (FileUtils.isPrefixOf((IPath)p, (IPath)path)) {
                return true;
            }
            try {
                if (!Files.isSameFile(nativePath, p.toFile().toPath())) continue;
                return true;
            }
            catch (IOException e) {
                Log.log((Throwable)e);
            }
        }
        return false;
    }

    public static boolean isRootPath(String data, Set<IPath> rootPaths) {
        java.nio.file.Path nativePath = new File(data).toPath();
        for (IPath p : rootPaths) {
            try {
                if (!Files.isSameFile(nativePath, p.toFile().toPath())) continue;
                return true;
            }
            catch (IOException e) {
                Log.log((Throwable)e);
            }
        }
        return false;
    }

    public static HashSet<IPath> getRootPaths(boolean addInterpreterInfoSubstitutions) {
        IProject[] projects;
        HashSet<IPath> rootPaths = new HashSet<IPath>();
        if (SharedCorePlugin.inTestMode()) {
            return rootPaths;
        }
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IPath rootLocation = root.getLocation().makeAbsolute();
        rootPaths.add(rootLocation);
        IProject[] iProjectArray = projects = root.getProjects();
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            PythonNature nature;
            IProject iProject = iProjectArray[n2];
            IPath location = iProject.getLocation();
            if (location != null) {
                IPath abs = location.makeAbsolute();
                rootPaths.add(abs);
            }
            if ((nature = PythonNature.getPythonNature(iProject)) != null) {
                try {
                    List splitted = nature.getPythonPathNature().getOnlyProjectPythonPathStr(true, addInterpreterInfoSubstitutions);
                    for (String s : splitted) {
                        try {
                            rootPaths.add(Path.fromOSString((String)FileUtils.getFileAbsolutePath((String)s)));
                        }
                        catch (Exception e) {
                            Log.log((Throwable)e);
                        }
                    }
                }
                catch (CoreException e) {
                    Log.log((Throwable)e);
                }
            }
            ++n2;
        }
        return rootPaths;
    }
}

