/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.ast.interpreter_managers;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.python.pydev.core.IInterpreterInfo;
import org.python.pydev.core.IInterpreterManager;
import org.python.pydev.core.IPythonNature;
import org.python.pydev.core.MisconfigurationException;
import org.python.pydev.core.log.Log;
import org.python.pydev.plugin.nature.PythonNature;
import org.python.pydev.plugin.nature.SystemPythonNature;
import org.python.pydev.shared_core.io.FileUtils;
import org.python.pydev.shared_core.structure.Tuple;

public class InterpreterManagersAPI {
    public static IInterpreterManager pythonInterpreterManager;
    public static IInterpreterManager jythonInterpreterManager;
    public static IInterpreterManager ironpythonInterpreterManager;

    public static void setPythonInterpreterManager(IInterpreterManager interpreterManager) {
        pythonInterpreterManager = interpreterManager;
    }

    public static IInterpreterManager getPythonInterpreterManager() {
        return InterpreterManagersAPI.getPythonInterpreterManager(false);
    }

    public static IInterpreterManager getPythonInterpreterManager(boolean haltOnStub) {
        return pythonInterpreterManager;
    }

    public static void setJythonInterpreterManager(IInterpreterManager interpreterManager) {
        jythonInterpreterManager = interpreterManager;
    }

    public static IInterpreterManager getJythonInterpreterManager() {
        return InterpreterManagersAPI.getJythonInterpreterManager(false);
    }

    public static IInterpreterManager getJythonInterpreterManager(boolean haltOnStub) {
        return jythonInterpreterManager;
    }

    public static void setIronpythonInterpreterManager(IInterpreterManager interpreterManager) {
        ironpythonInterpreterManager = interpreterManager;
    }

    public static IInterpreterManager getIronpythonInterpreterManager(boolean haltOnStub) {
        return ironpythonInterpreterManager;
    }

    public static IInterpreterManager getIronpythonInterpreterManager() {
        return InterpreterManagersAPI.getIronpythonInterpreterManager(false);
    }

    public static IInterpreterManager[] getAllInterpreterManagers() {
        return new IInterpreterManager[]{InterpreterManagersAPI.getPythonInterpreterManager(), InterpreterManagersAPI.getJythonInterpreterManager(), InterpreterManagersAPI.getIronpythonInterpreterManager()};
    }

    public static List<IInterpreterInfo> getAllInterpreterInfos() {
        IInterpreterManager[] allInterpreterManagers;
        ArrayList<IInterpreterInfo> infos = new ArrayList<IInterpreterInfo>();
        IInterpreterManager[] iInterpreterManagerArray = allInterpreterManagers = InterpreterManagersAPI.getAllInterpreterManagers();
        int n = allInterpreterManagers.length;
        int n2 = 0;
        while (n2 < n) {
            IInterpreterManager iInterpreterManager = iInterpreterManagerArray[n2];
            if (iInterpreterManager != null) {
                infos.addAll(Arrays.asList(iInterpreterManager.getInterpreterInfos()));
            }
            ++n2;
        }
        return infos;
    }

    public static IInterpreterManager getInterpreterManager(IPythonNature nature) {
        try {
            return InterpreterManagersAPI.getInterpreterManagerFromType(nature.getInterpreterType());
        }
        catch (CoreException e) {
            throw new RuntimeException(e);
        }
    }

    public static IInterpreterManager getInterpreterManagerFromType(int interpreterType) {
        try {
            switch (interpreterType) {
                case 1: {
                    return jythonInterpreterManager;
                }
                case 0: {
                    return pythonInterpreterManager;
                }
                case 2: {
                    return ironpythonInterpreterManager;
                }
            }
            throw new RuntimeException("Unable to get the interpreter manager for unknown interpreter type: " + interpreterType);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static Tuple<IPythonNature, String> getInfoForManager(File file, IInterpreterManager pythonInterpreterManager) {
        if (pythonInterpreterManager != null && pythonInterpreterManager.isConfigured()) {
            IInterpreterInfo[] interpreterInfos;
            IInterpreterInfo[] iInterpreterInfoArray = interpreterInfos = pythonInterpreterManager.getInterpreterInfos();
            int n = interpreterInfos.length;
            int n2 = 0;
            while (n2 < n) {
                IInterpreterInfo iInterpreterInfo = iInterpreterInfoArray[n2];
                try {
                    SystemPythonNature systemPythonNature = new SystemPythonNature(pythonInterpreterManager, iInterpreterInfo);
                    String modName = systemPythonNature.resolveModule(file);
                    if (modName != null) {
                        return new Tuple((Object)systemPythonNature, (Object)modName);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ++n2;
            }
        }
        return null;
    }

    public static String getModNameFromFile(File file) {
        if (file == null) {
            return null;
        }
        String name = file.getName();
        int i = name.indexOf(46);
        if (i != -1) {
            return name.substring(0, i);
        }
        return name;
    }

    public static Tuple<IPythonNature, String> getInfoForFile(File file) {
        IInterpreterManager pythonInterpreterManager2 = InterpreterManagersAPI.getPythonInterpreterManager(false);
        IInterpreterManager jythonInterpreterManager2 = InterpreterManagersAPI.getJythonInterpreterManager(false);
        IInterpreterManager ironpythonInterpreterManager2 = InterpreterManagersAPI.getIronpythonInterpreterManager(false);
        if (file != null) {
            Tuple<IPythonNature, String> infoForManager = InterpreterManagersAPI.getInfoForManager(file, pythonInterpreterManager2);
            if (infoForManager != null) {
                return infoForManager;
            }
            infoForManager = InterpreterManagersAPI.getInfoForManager(file, jythonInterpreterManager2);
            if (infoForManager != null) {
                return infoForManager;
            }
            infoForManager = InterpreterManagersAPI.getInfoForManager(file, ironpythonInterpreterManager2);
            if (infoForManager != null) {
                return infoForManager;
            }
            List<IPythonNature> allPythonNatures = PythonNature.getAllPythonNatures();
            int size = allPythonNatures.size();
            int i = 0;
            while (i < size) {
                IPythonNature nature = allPythonNatures.get(i);
                try {
                    String modName = nature.resolveModuleOnlyInProjectSources(FileUtils.getFileAbsolutePath((File)file), true);
                    if (modName != null) {
                        return new Tuple((Object)nature, (Object)modName);
                    }
                }
                catch (Exception e) {
                    Log.log((Throwable)e);
                }
                ++i;
            }
        }
        if (pythonInterpreterManager2.isConfigured()) {
            try {
                return new Tuple((Object)new SystemPythonNature(pythonInterpreterManager2), (Object)InterpreterManagersAPI.getModNameFromFile(file));
            }
            catch (MisconfigurationException misconfigurationException) {
                // empty catch block
            }
        }
        if (jythonInterpreterManager2.isConfigured()) {
            try {
                return new Tuple((Object)new SystemPythonNature(jythonInterpreterManager2), (Object)InterpreterManagersAPI.getModNameFromFile(file));
            }
            catch (MisconfigurationException misconfigurationException) {
                // empty catch block
            }
        }
        if (ironpythonInterpreterManager2.isConfigured()) {
            try {
                return new Tuple((Object)new SystemPythonNature(ironpythonInterpreterManager2), (Object)InterpreterManagersAPI.getModNameFromFile(file));
            }
            catch (MisconfigurationException misconfigurationException) {
                // empty catch block
            }
        }
        try {
            pythonInterpreterManager2.getDefaultInterpreterInfo(true);
        }
        catch (MisconfigurationException misconfigurationException) {
            // empty catch block
        }
        return null;
    }

    public static Map<IInterpreterManager, Map<String, IInterpreterInfo>> getInterpreterManagerToInterpreterNameToInfo() {
        HashMap<IInterpreterManager, Map<String, IInterpreterInfo>> managerToNameToInfo = new HashMap<IInterpreterManager, Map<String, IInterpreterInfo>>();
        IInterpreterManager[] allInterpreterManagers = InterpreterManagersAPI.getAllInterpreterManagers();
        int i = 0;
        while (i < allInterpreterManagers.length) {
            IInterpreterManager manager = allInterpreterManagers[i];
            if (manager != null) {
                HashMap<String, IInterpreterInfo> nameToInfo = new HashMap<String, IInterpreterInfo>();
                managerToNameToInfo.put(manager, nameToInfo);
                IInterpreterInfo[] interpreterInfos = manager.getInterpreterInfos();
                int j = 0;
                while (j < interpreterInfos.length) {
                    IInterpreterInfo internalInfo = interpreterInfos[j];
                    nameToInfo.put(internalInfo.getName(), internalInfo);
                    ++j;
                }
            }
            ++i;
        }
        return managerToNameToInfo;
    }
}

