/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.ast.listing_utils;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.python.pydev.ast.codecompletion.revisited.PythonPathHelper;
import org.python.pydev.core.log.Log;
import org.python.pydev.core.preferences.FileTypesPreferences;
import org.python.pydev.shared_core.string.FastStringBuffer;
import org.python.pydev.shared_core.string.StringUtils;
import org.python.pydev.shared_core.structure.LinkedListWarningOnSlowOperations;

public class PyFileListing {
    private final List<PyFileInfo> pyFileInfos = new ArrayList<PyFileInfo>();
    private List<File> foldersFound = new ArrayList<File>();

    private static void getPyFilesBelowDirectory(PyFileListing result, Path path, PyFileListingFilter filter, IProgressMonitor monitor, boolean addSubFolders, int level, String currModuleRep, Set<File> canonicalFolders) {
        Serializable canonicalizedDir;
        FastStringBuffer buf = new FastStringBuffer(currModuleRep, 128);
        if (level != 0) {
            FastStringBuffer newModuleRep = buf;
            if (newModuleRep.length() != 0) {
                newModuleRep.append('.');
            }
            newModuleRep.append(path.getFileName().toString());
            currModuleRep = newModuleRep.toString();
        }
        try {
            if (Files.isSymbolicLink(path)) {
                File file = path.toFile();
                canonicalizedDir = file.getCanonicalFile();
                if (!((File)canonicalizedDir).equals(file) && canonicalFolders.contains(canonicalizedDir)) {
                    return;
                }
                canonicalFolders.add((File)canonicalizedDir);
            }
        }
        catch (IOException e) {
            return;
        }
        result.foldersFound.add(path.toFile());
        LinkedListWarningOnSlowOperations foldersLater = new LinkedListWarningOnSlowOperations();
        try {
            canonicalizedDir = null;
            Iterator iterator = null;
            try (DirectoryStream<Path> stream = Files.newDirectoryStream(path);){
                for (Path subpath : stream) {
                    if (monitor.isCanceled()) {
                        break;
                    }
                    File subpathFile = subpath.toFile();
                    boolean isDirectory = Files.isSymbolicLink(subpath) ? subpathFile.isDirectory() : Files.isDirectory(subpath, new LinkOption[0]);
                    if (filter != null && !filter.accept(subpath, subpathFile, isDirectory)) continue;
                    if (!isDirectory) {
                        result.addPyFileInfo(new PyFileInfo(subpathFile, currModuleRep));
                        monitor.worked(1);
                        monitor.setTaskName(buf.clear().append("Found:").append(subpathFile.toString()).toString());
                        continue;
                    }
                    if (!addSubFolders) continue;
                    foldersLater.add(subpath);
                }
            }
            catch (Throwable throwable) {
                if (canonicalizedDir == null) {
                    canonicalizedDir = throwable;
                } else if (canonicalizedDir != throwable) {
                    ((Throwable)canonicalizedDir).addSuppressed(throwable);
                }
                throw canonicalizedDir;
            }
        }
        catch (Exception e) {
            Log.log((Throwable)e);
        }
        for (Path folder : foldersLater) {
            if (monitor.isCanceled()) break;
            PyFileListing.getPyFilesBelowDirectory(result, folder, filter, monitor, addSubFolders, level + 1, currModuleRep, canonicalFolders);
            monitor.worked(1);
        }
    }

    private static PyFileListing getPyFilesBelowInitial(PyFileListing result, File file, PyFileListingFilter filter, IProgressMonitor monitor, boolean addSubFolders, int level, String currModuleRep, Set<File> canonicalFolders) {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        if (file != null && file.exists()) {
            if (file.isDirectory()) {
                PyFileListing.getPyFilesBelowDirectory(result, file.toPath(), filter, monitor, addSubFolders, level, currModuleRep, canonicalFolders);
            } else {
                result.addPyFileInfo(new PyFileInfo(file, currModuleRep));
            }
        }
        return result;
    }

    private static PyFileListing getPyFilesBelow(File file, PyFileListingFilter filter, IProgressMonitor monitor, boolean addSubFolders) {
        PyFileListing result = new PyFileListing();
        return PyFileListing.getPyFilesBelowInitial(result, file, filter, monitor, addSubFolders, 0, "", new HashSet<File>());
    }

    public static PyFileListing getPyFilesBelow(File file, PyFileListingFilter filter, IProgressMonitor monitor) {
        return PyFileListing.getPyFilesBelow(file, filter, monitor, true);
    }

    public static PyFileListingFilter getPyFilesFileFilter(final boolean includeDirs) {
        return new PyFileListingFilter(){
            private final String[] dottedValidSourceFiles = FileTypesPreferences.getDottedValidSourceFiles();

            @Override
            public boolean accept(Path pathname, File file, boolean isDirectory) {
                if (isDirectory) {
                    return includeDirs;
                }
                return PythonPathHelper.isValidSourceFile(file.toString(), this.dottedValidSourceFiles);
            }
        };
    }

    public static PyFileListing getPyFilesBelow(File file, IProgressMonitor monitor, boolean includeDirs) {
        PyFileListingFilter filter = PyFileListing.getPyFilesFileFilter(includeDirs);
        return PyFileListing.getPyFilesBelow(file, filter, monitor, true);
    }

    public static List<IFile> getAllIFilesBelow(IContainer member) {
        final ArrayList<IFile> ret = new ArrayList<IFile>();
        try {
            member.accept(new IResourceVisitor(){

                public boolean visit(IResource resource) {
                    if (resource instanceof IFile) {
                        ret.add((IFile)resource);
                        return false;
                    }
                    return true;
                }
            });
        }
        catch (CoreException e) {
            throw new RuntimeException(e);
        }
        return ret;
    }

    public Collection<PyFileInfo> getFoundPyFileInfos() {
        return this.pyFileInfos;
    }

    public Collection<File> getFoundFolders() {
        return this.foldersFound;
    }

    private void addPyFileInfo(PyFileInfo info) {
        this.pyFileInfos.add(info);
    }

    public static final class PyFileInfo {
        private final String relPath;
        private final File file;

        public PyFileInfo(File file, String relPath) {
            this.file = file;
            this.relPath = relPath;
        }

        public File getFile() {
            return this.file;
        }

        public String getPackageName() {
            return this.relPath;
        }

        public String toString() {
            return StringUtils.join((String)"", (Object[])new Object[]{"PyFileInfo:", this.file, " - ", this.relPath});
        }

        public String getModuleName(FastStringBuffer temp) {
            String scannedModuleName = this.getPackageName();
            String name = PythonPathHelper.getValidName(this.file.getName());
            String modName = scannedModuleName.length() != 0 ? temp.clear().append(scannedModuleName).append('.').append(name).toString() : name;
            return modName;
        }
    }

    public static interface PyFileListingFilter {
        public boolean accept(Path var1, File var2, boolean var3);
    }
}

