/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.ast.package_managers;

import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.python.pydev.ast.interpreter_managers.InterpreterInfo;
import org.python.pydev.ast.package_managers.NameAndExecutable;
import org.python.pydev.ast.runners.SimpleRunner;
import org.python.pydev.core.log.Log;
import org.python.pydev.json.eclipsesource.JsonArray;
import org.python.pydev.json.eclipsesource.JsonObject;
import org.python.pydev.json.eclipsesource.JsonValue;
import org.python.pydev.plugin.nature.PythonNature;
import org.python.pydev.shared_core.io.FileUtils;
import org.python.pydev.shared_core.structure.OrderedSet;
import org.python.pydev.shared_core.structure.Tuple;
import org.python.pydev.shared_core.utils.PlatformUtils;

public class CondaCore {
    public static List<File> listCondaEnvironments(File condaExecutable) {
        String encoding = "utf-8";
        Tuple<String, String> output = new SimpleRunner().runAndGetOutput(new String[]{condaExecutable.toString(), "env", "list", "--json"}, null, null, null, encoding);
        Log.logInfo((String)((String)output.o1));
        if (output.o2 != null && ((String)output.o2).length() > 0) {
            Log.logInfo((String)("STDERR when listing conda environments:\n" + (String)output.o2));
        }
        JsonObject jsonOutput = JsonValue.readFrom((String)((String)output.o1)).asObject();
        JsonArray envs = jsonOutput.get("envs").asArray();
        HashSet<File> set = new HashSet<File>();
        for (JsonValue env : envs.values()) {
            set.add(new File(env.asString()));
        }
        return new ArrayList<File>(set);
    }

    public static List<NameAndExecutable> getCondaEnvsAsNameAndExecutable(List<File> envs) {
        ArrayList<NameAndExecutable> ret = new ArrayList<NameAndExecutable>();
        if (PlatformUtils.isWindowsPlatform()) {
            for (File env : envs) {
                File exec = new File(env, "python.exe");
                if (FileUtils.enhancedIsFile((File)exec)) {
                    ret.add(new NameAndExecutable(env.getName(), exec.getPath()));
                    continue;
                }
                Log.logInfo((String)("Did not find: " + String.valueOf(exec) + " in conda environment."));
            }
        } else {
            for (File env : envs) {
                File exec = new File(new File(env, "bin"), "python");
                if (FileUtils.enhancedIsFile((File)exec)) {
                    ret.add(new NameAndExecutable(env.getName(), exec.getPath()));
                    continue;
                }
                Log.logInfo((String)("Did not find: " + String.valueOf(exec) + " in conda environment."));
            }
        }
        return ret;
    }

    public static File findCondaExecutableInSystem() {
        File condaExecutable = null;
        OrderedSet pathsToSearch = new OrderedSet(PythonNature.getPathsToSearch());
        String userHomeDir = System.getProperty("user.home");
        if (PlatformUtils.isWindowsPlatform()) {
            pathsToSearch.add((Object)"c:/tools/miniconda");
            pathsToSearch.add((Object)"c:/tools/miniconda2");
            pathsToSearch.add((Object)"c:/tools/miniconda3");
            pathsToSearch.add((Object)"c:/tools/conda");
            pathsToSearch.add((Object)"c:/tools/conda2");
            pathsToSearch.add((Object)"c:/tools/conda3");
        } else {
            pathsToSearch.add((Object)"/opt/conda");
            pathsToSearch.add((Object)"/opt/conda/bin");
            pathsToSearch.add((Object)"/usr/bin");
        }
        pathsToSearch.add((Object)new File(userHomeDir, "miniconda").toString());
        pathsToSearch.add((Object)new File(userHomeDir, "miniconda2").toString());
        pathsToSearch.add((Object)new File(userHomeDir, "miniconda3").toString());
        pathsToSearch.add((Object)new File(userHomeDir, "conda").toString());
        pathsToSearch.add((Object)new File(userHomeDir, "conda2").toString());
        pathsToSearch.add((Object)new File(userHomeDir, "conda3").toString());
        pathsToSearch.add((Object)new File(userHomeDir, "Anaconda").toString());
        pathsToSearch.add((Object)new File(userHomeDir, "Anaconda2").toString());
        pathsToSearch.add((Object)new File(userHomeDir, "Anaconda3").toString());
        pathsToSearch.add((Object)new File(userHomeDir).toString());
        ArrayList<File> searchedDirectories = new ArrayList<File>();
        for (String string : pathsToSearch) {
            File file = InterpreterInfo.searchExecutableInContainer("conda", new File(string), searchedDirectories);
            if (file == null) continue;
            condaExecutable = file;
        }
        return condaExecutable;
    }
}

