/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.ast.refactoring;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.python.pydev.core.IModule;
import org.python.pydev.parser.jython.ast.ClassDef;
import org.python.pydev.parser.visitors.NodeUtils;
import org.python.pydev.shared_core.model.ISimpleNode;

public class HierarchyNodeModel {
    public String name;
    public List<HierarchyNodeModel> parents = new ArrayList<HierarchyNodeModel>(5);
    public List<HierarchyNodeModel> children = new ArrayList<HierarchyNodeModel>(5);
    public String moduleName;
    public ClassDef ast;
    public IModule module;

    public HierarchyNodeModel(String name) {
        this(name, "", null);
    }

    public HierarchyNodeModel(String pack, ClassDef ast) {
        this(NodeUtils.getRepresentationString((ISimpleNode)ast), pack, ast);
    }

    public HierarchyNodeModel(String name, String pack, ClassDef ast) {
        Assert.isNotNull((Object)name);
        if (pack == null) {
            pack = "";
        }
        this.name = name;
        this.moduleName = pack;
        this.ast = ast;
    }

    public HierarchyNodeModel(IModule module, ClassDef def) {
        this(module.getName(), def);
        this.module = module;
    }

    public String toString() {
        return "HierarchyNodeModel[" + this.name + " - " + this.moduleName + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.moduleName == null ? 0 : this.moduleName.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HierarchyNodeModel)) {
            return false;
        }
        HierarchyNodeModel other = (HierarchyNodeModel)obj;
        if (this.moduleName == null ? other.moduleName != null : !this.moduleName.equals(other.moduleName)) {
            return false;
        }
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }
}

