/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.ast.refactoring;

import java.io.File;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.TextUtilities;
import org.python.pydev.ast.adapters.AbstractScopeNode;
import org.python.pydev.ast.adapters.IClassDefAdapter;
import org.python.pydev.ast.adapters.ModuleAdapter;
import org.python.pydev.ast.adapters.PythonModuleManager;
import org.python.pydev.ast.adapters.visitors.VisitorFactory;
import org.python.pydev.ast.interpreter_managers.InterpreterManagersAPI;
import org.python.pydev.core.IGrammarVersionProvider;
import org.python.pydev.core.IIndentPrefs;
import org.python.pydev.core.IPyEdit;
import org.python.pydev.core.IPythonNature;
import org.python.pydev.core.MisconfigurationException;
import org.python.pydev.core.autoedit.DefaultIndentPrefs;
import org.python.pydev.core.autoedit.TestIndentPrefs;
import org.python.pydev.core.docutils.PySelection;
import org.python.pydev.core.log.Log;
import org.python.pydev.parser.PyParser;
import org.python.pydev.parser.jython.ParseException;
import org.python.pydev.parser.jython.TokenMgrError;
import org.python.pydev.parser.jython.ast.Expr;
import org.python.pydev.parser.jython.ast.Module;
import org.python.pydev.parser.jython.ast.exprType;
import org.python.pydev.parser.jython.ast.factory.AdapterPrefs;
import org.python.pydev.parser.jython.ast.stmtType;
import org.python.pydev.shared_core.SharedCorePlugin;
import org.python.pydev.shared_core.string.CoreTextSelection;
import org.python.pydev.shared_core.string.ICoreTextSelection;
import org.python.pydev.shared_core.structure.LinkedListWarningOnSlowOperations;
import org.python.pydev.shared_core.structure.Tuple;

public class RefactoringInfo {
    private final IFile sourceFile;
    private IDocument doc;
    private ICoreTextSelection userSelection;
    private ModuleAdapter moduleAdapter;
    private final IPythonNature nature;
    private final IGrammarVersionProvider versionProvider;
    public final IIndentPrefs indentPrefs;
    private PythonModuleManager moduleManager;
    private AbstractScopeNode<?> scopeAdapter;
    private IProject project;
    private File realFile;

    public RefactoringInfo(IPyEdit edit) throws MisconfigurationException {
        this(edit, edit.getTextSelection());
    }

    public RefactoringInfo(IDocument document, ICoreTextSelection selection, IGrammarVersionProvider versionProvider) {
        this.sourceFile = null;
        this.nature = null;
        this.versionProvider = versionProvider;
        this.doc = document;
        this.indentPrefs = SharedCorePlugin.inTestMode() ? new TestIndentPrefs(document.get().indexOf(9) < 0, 4) : DefaultIndentPrefs.get(null);
        this.initInfo(selection);
    }

    public RefactoringInfo(IPyEdit edit, ICoreTextSelection selection) throws MisconfigurationException {
        Tuple<IPythonNature, String> infoForFile;
        this.indentPrefs = edit.getIndentPrefs();
        IPythonNature localNature = edit.getPythonNature();
        this.sourceFile = edit.getIFile();
        this.realFile = edit.getEditorFile();
        if (localNature == null && (infoForFile = InterpreterManagersAPI.getInfoForFile(this.realFile)) != null && infoForFile.o1 != null) {
            localNature = (IPythonNature)infoForFile.o1;
        }
        this.nature = localNature;
        this.doc = edit.getDocument();
        this.project = edit.getProject();
        this.versionProvider = this.nature;
        this.initInfo(selection);
    }

    private void initInfo(ICoreTextSelection selection) {
        if (this.nature != null) {
            this.moduleManager = new PythonModuleManager(this.nature);
        }
        try {
            this.moduleAdapter = VisitorFactory.createModuleAdapter(this.moduleManager, this.realFile, this.doc, this.nature, this.versionProvider, true);
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
        this.userSelection = this.moduleAdapter.normalizeSelection(selection);
    }

    public IProject getProject() {
        return this.project;
    }

    public ModuleAdapter getModuleAdapter() {
        return this.moduleAdapter;
    }

    public List<IClassDefAdapter> getClasses() {
        return this.moduleAdapter.getClasses();
    }

    public IFile getSourceFile() {
        return this.sourceFile;
    }

    public IDocument getDocument() {
        return this.doc;
    }

    public SelectionComputer getSelectionComputer(SelectionComputer.SelectionComputerKind kind) {
        return new SelectionComputer(this, kind);
    }

    private ICoreTextSelection getExtendedSelection() {
        if (this.getScopeAdapter() != null) {
            return this.moduleAdapter.normalizeSelection(VisitorFactory.createSelectionExtension(this.getScopeAdapter(), this.userSelection));
        }
        return null;
    }

    private ICoreTextSelection getUserSelection() {
        return this.userSelection;
    }

    private ModuleAdapter getParsedSelection(ICoreTextSelection selection) {
        ModuleAdapter parsedAdapter = null;
        String source = this.normalizeSourceSelection(selection);
        if (selection != null && source.length() > 0) {
            try {
                parsedAdapter = VisitorFactory.createModuleAdapter(this.moduleManager, null, (IDocument)new Document(source), this.nature, this.versionProvider);
            }
            catch (TokenMgrError e) {
                return null;
            }
            catch (ParseException e) {
                return null;
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        }
        return parsedAdapter;
    }

    public String normalizeSourceSelection(ICoreTextSelection selection) {
        if (selection == null) {
            return "";
        }
        String selectedText = "";
        if (selection.getText() != null) {
            selectedText = selection.getText().trim();
        }
        if (selectedText.length() == 0) {
            return "";
        }
        try {
            return this.normalizeBlockIndentation(selection, selectedText);
        }
        catch (Throwable throwable) {
            return selectedText;
        }
    }

    private String normalizeBlockIndentation(ICoreTextSelection selection, String selectedText) throws Throwable {
        String[] lines = selectedText.split("\\n");
        if (lines.length < 2) {
            return selectedText;
        }
        String firstLine = this.doc.get(this.doc.getLineOffset(selection.getStartLine()), this.doc.getLineLength(selection.getStartLine()));
        String lineDelimiter = TextUtilities.getDefaultLineDelimiter((IDocument)this.doc);
        Object indentation = "";
        int bodyIndent = 0;
        while (firstLine.startsWith(" ")) {
            indentation = (String)indentation + " ";
            firstLine = firstLine.substring(1);
            ++bodyIndent;
        }
        if (bodyIndent > 0) {
            StringBuffer selectedCode = new StringBuffer();
            String[] stringArray = lines;
            int n = lines.length;
            int n2 = 0;
            while (n2 < n) {
                String line = stringArray[n2];
                if (line.startsWith((String)indentation)) {
                    selectedCode.append(line.substring(bodyIndent) + lineDelimiter);
                } else {
                    selectedCode.append(line + lineDelimiter);
                }
                ++n2;
            }
            selectedText = selectedCode.toString();
        }
        return selectedText;
    }

    public IClassDefAdapter getScopeClass() {
        return this.moduleAdapter.getScopeClass(this.getUserSelection());
    }

    public IPythonNature getNature() {
        return this.nature;
    }

    public List<IClassDefAdapter> getScopeClassAndBases() throws MisconfigurationException {
        return this.moduleAdapter.getClassHierarchy(this.getScopeClass());
    }

    public AbstractScopeNode<?> getScopeAdapter() {
        if (this.scopeAdapter == null) {
            this.scopeAdapter = this.moduleAdapter.getScopeAdapter(this.userSelection);
        }
        return this.scopeAdapter;
    }

    public String getNewLineDelim() {
        return TextUtilities.getDefaultLineDelimiter((IDocument)this.doc);
    }

    public AdapterPrefs getAdapterPrefs() {
        return new AdapterPrefs(this.getNewLineDelim(), this.versionProvider);
    }

    public PySelection getPySelection() {
        return new PySelection(this.doc, this.userSelection);
    }

    public IGrammarVersionProvider getVersionProvider() {
        return this.versionProvider;
    }

    public static class SelectionComputer {
        public final ICoreTextSelection selection;
        public final ModuleAdapter selectionModuleAdapter;

        public SelectionComputer(RefactoringInfo info, SelectionComputerKind kind) {
            ICoreTextSelection extendedSelection;
            LinkedListWarningOnSlowOperations selections = new LinkedListWarningOnSlowOperations();
            ICoreTextSelection userSelection = info.getUserSelection();
            if (userSelection.getLength() > 0) {
                selections.add(new Tuple((Object)userSelection, (Object)info.getParsedSelection(userSelection)));
            }
            if ((extendedSelection = info.getExtendedSelection()) != null && extendedSelection.getLength() > 0) {
                selections.add(new Tuple((Object)extendedSelection, (Object)info.getParsedSelection(extendedSelection)));
            }
            if (userSelection.getLength() > 0) {
                selections.add(new Tuple((Object)userSelection, (Object)this.getParsedMultilineSelection(info, userSelection)));
            }
            IDocument doc = info.getDocument();
            int startOffset = userSelection.getOffset();
            int endOffset = userSelection.getOffset() + userSelection.getLength();
            int i = startOffset - 1;
            while (i >= 0) {
                try {
                    char c = doc.getChar(i);
                    if (!Character.isJavaIdentifierPart(c)) break;
                    startOffset = i--;
                }
                catch (BadLocationException e) {
                    break;
                }
            }
            int length = doc.getLength();
            int i2 = endOffset;
            while (i2 < length) {
                try {
                    char c = doc.getChar(i2);
                    if (!Character.isJavaIdentifierPart(c)) break;
                    endOffset = i2 + 1;
                }
                catch (BadLocationException e) {
                    break;
                }
                ++i2;
            }
            CoreTextSelection sel = new CoreTextSelection(info.getDocument(), startOffset, endOffset - startOffset);
            if (sel.getLength() > 0) {
                selections.add(new Tuple((Object)sel, (Object)info.getParsedSelection((ICoreTextSelection)sel)));
            }
            ICoreTextSelection selection = null;
            ModuleAdapter selectionModuleAdapter = null;
            for (Tuple s : selections) {
                if (s == null || s.o1 == null || s.o2 == null || (kind == SelectionComputerKind.inline ? this.extractExpression((ModuleAdapter)s.o2) == null : !this.isValidWhenCodeExtracted(info, (ICoreTextSelection)s.o1, info.getDocument()))) continue;
                selection = (ICoreTextSelection)s.o1;
                selectionModuleAdapter = (ModuleAdapter)s.o2;
            }
            this.selectionModuleAdapter = selectionModuleAdapter;
            this.selection = selection;
        }

        public exprType getSingleExpression() {
            exprType expression = this.extractExpression(this.selectionModuleAdapter);
            return expression;
        }

        private boolean isValidWhenCodeExtracted(RefactoringInfo info, ICoreTextSelection o1, IDocument document) {
            try {
                String text = o1.getText();
                int firstNonWhitespace = 0;
                int i = 0;
                while (i < text.length()) {
                    if (!Character.isWhitespace(text.charAt(i))) {
                        firstNonWhitespace = i;
                        break;
                    }
                    ++i;
                }
                int lastNonWhitespace = 0;
                int i2 = text.length() - 1;
                while (i2 >= 0) {
                    if (!Character.isWhitespace(text.charAt(i2))) break;
                    ++lastNonWhitespace;
                    --i2;
                }
                Document temp = new Document(document.get());
                temp.replace(o1.getOffset() + firstNonWhitespace, o1.getLength() - (firstNonWhitespace + lastNonWhitespace), "call()");
                Module rootNode = PyParser.parseSimple((IDocument)temp, (IGrammarVersionProvider)info.getVersionProvider());
                return rootNode != null;
            }
            catch (Exception e) {
                return false;
            }
        }

        private exprType extractExpression(ModuleAdapter node) {
            if (node == null) {
                return null;
            }
            Module astNode = (Module)node.getASTNode();
            if (astNode == null) {
                return null;
            }
            stmtType[] body = astNode.body;
            if (body.length > 0 && body[0] instanceof Expr) {
                Expr expr = (Expr)body[0];
                return expr.value;
            }
            return null;
        }

        private ModuleAdapter getParsedMultilineSelection(RefactoringInfo info, ICoreTextSelection selection) {
            String source = selection.getText();
            source = source.replaceAll("\n", "");
            source = source.replaceAll("\r", "");
            try {
                ModuleAdapter node = VisitorFactory.createModuleAdapter(null, null, (IDocument)new Document(source), null, info.getVersionProvider());
                return node;
            }
            catch (TokenMgrError e) {
                return null;
            }
            catch (ParseException e) {
                return null;
            }
            catch (Throwable e) {
                Log.log((Throwable)e);
                return null;
            }
        }

        public static enum SelectionComputerKind {
            inline,
            extractMethod,
            extractLocal;

        }
    }
}

