/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.ast.runners;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.AssertionFailedException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.python.copiedfromeclipsesrc.JDTNotAvailableException;
import org.python.pydev.ast.AstPlugin;
import org.python.pydev.ast.interpreter_managers.InterpreterInfo;
import org.python.pydev.ast.interpreter_managers.InterpreterManagersAPI;
import org.python.pydev.ast.listing_utils.JavaVmLocationFinder;
import org.python.pydev.ast.runners.SimpleRunner;
import org.python.pydev.core.IInterpreterManager;
import org.python.pydev.core.MisconfigurationException;
import org.python.pydev.core.preferences.PydevPrefs;
import org.python.pydev.plugin.nature.PythonNature;
import org.python.pydev.shared_core.io.FileUtils;
import org.python.pydev.shared_core.process.ProcessUtils;
import org.python.pydev.shared_core.string.FastStringBuffer;
import org.python.pydev.shared_core.string.StringUtils;
import org.python.pydev.shared_core.structure.Tuple;
import org.python.pydev.shared_core.utils.ArrayUtils;

public class SimpleJythonRunner
extends SimpleRunner {
    public Tuple<String, String> runAndGetOutputWithJar(String script, String jythonJar, String[] args, File workingDir, IProject project, IProgressMonitor monitor, String encoding) {
        File javaExecutable = JavaVmLocationFinder.findDefaultJavaExecutable();
        if (javaExecutable == null) {
            throw new JavaNotConfiguredException("Error: the java environment must be configured before jython.\n\nPlease make sure that the java executable to be\nused is correctly configured in the preferences at:\n\nJava > Installed JREs.");
        }
        return this.runAndGetOutputWithJar(javaExecutable, script, jythonJar, args, workingDir, project, monitor, null, encoding);
    }

    public Tuple<String, String> runAndGetOutputWithJar(File javaExecutable, String script, String jythonJar, String[] args, File workingDir, IProject project, IProgressMonitor monitor, String additionalPythonpath, String encoding) {
        try {
            String[] s;
            String javaLoc = FileUtils.getFileAbsolutePath((File)javaExecutable);
            String pythonHome = new File((String)jythonJar).getParent().toString();
            if (additionalPythonpath != null) {
                jythonJar = (String)jythonJar + SimpleRunner.getPythonPathSeparator();
                jythonJar = (String)jythonJar + additionalPythonpath;
                s = new String[]{javaLoc, "-Dpython.path=" + additionalPythonpath, "-Dpython.home=" + pythonHome, "-classpath", jythonJar, "org.python.util.jython", script};
            } else {
                s = new String[]{javaLoc, "-Dpython.home=" + pythonHome, "-classpath", jythonJar, "org.python.util.jython", script};
            }
            if (args != null && args.length > 0) {
                s = (String[])ArrayUtils.concatArrays((Object[][])new String[][]{s, args});
            }
            return this.runAndGetOutput(s, workingDir, PythonNature.getPythonNature(project), monitor, encoding);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String[] makeExecutableCommandStr(String jythonJar, String script, String basePythonPath, String ... args) throws IOException, JDTNotAvailableException, MisconfigurationException {
        return SimpleJythonRunner.makeExecutableCommandStrWithVMArgs(jythonJar, script, basePythonPath, "", args);
    }

    public static String[] makeExecutableCommandStrWithVMArgs(String jythonJar, String script, String basePythonPath, String vmArgs, String ... args) throws IOException, JDTNotAvailableException, MisconfigurationException {
        IInterpreterManager interpreterManager = InterpreterManagersAPI.getJythonInterpreterManager();
        String javaLoc = FileUtils.getFileAbsolutePath((File)JavaVmLocationFinder.findDefaultJavaExecutable());
        File file = new File(javaLoc);
        if (!file.exists()) {
            throw new RuntimeException("The java location found does not exist. " + javaLoc);
        }
        if (file.isDirectory()) {
            throw new RuntimeException("The java location found is a directory. " + javaLoc);
        }
        if (!new File(jythonJar).exists()) {
            throw new RuntimeException(StringUtils.format((String)"Error. The default configured interpreter: %s does not exist!", (Object[])new Object[]{jythonJar}));
        }
        InterpreterInfo info = (InterpreterInfo)interpreterManager.getInterpreterInfo(jythonJar, (IProgressMonitor)new NullProgressMonitor());
        String libs = SimpleRunner.makePythonPathEnvFromPaths(info.libs);
        FastStringBuffer jythonPath = new FastStringBuffer(basePythonPath, 128);
        String pathSeparator = SimpleRunner.getPythonPathSeparator();
        if (jythonPath.length() != 0) {
            jythonPath.append(pathSeparator);
        }
        jythonPath.append(libs);
        Object cacheDir = null;
        try {
            AstPlugin plugin = AstPlugin.getDefault();
            if (plugin != null) {
                IPath stateLocation = plugin.getStateLocation();
                File cacheDirFile = new File(stateLocation.toFile(), "jython_cache_dir");
                cacheDirFile.mkdirs();
                cacheDir = PydevPrefs.getEclipsePreferences().get("JYTHON_CACHE_DIR", cacheDirFile.toString());
            }
        }
        catch (AssertionFailedException e) {
            cacheDir = null;
        }
        if (cacheDir != null && ((String)cacheDir).trim().length() == 0) {
            cacheDir = null;
        }
        if (cacheDir != null) {
            cacheDir = "-Dpython.cachedir=" + ((String)cacheDir).trim();
        }
        String[] vmArgsList = ProcessUtils.parseArguments((String)vmArgs);
        String[] s = new String[]{"-Dpython.path=" + jythonPath.toString(), "-classpath", jythonJar + pathSeparator + String.valueOf(jythonPath), "org.python.util.jython", script};
        ArrayList<Object> asList = new ArrayList<Object>();
        asList.add(javaLoc);
        if (cacheDir != null) {
            asList.add(cacheDir);
        }
        asList.addAll(Arrays.asList(vmArgsList));
        asList.addAll(Arrays.asList(s));
        asList.addAll(Arrays.asList(args));
        return asList.toArray(new String[0]);
    }

    public static class JavaNotConfiguredException
    extends RuntimeException {
        public JavaNotConfiguredException(String string) {
            super(string);
        }
    }
}

