/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.ast.sort_imports;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.python.pydev.ast.formatter.PyFormatter;
import org.python.pydev.core.IPyFormatStdProvider;
import org.python.pydev.core.docutils.ImportHandle;
import org.python.pydev.core.docutils.PyImportsHandling;
import org.python.pydev.core.docutils.PySelection;
import org.python.pydev.core.formatter.FormatStd;
import org.python.pydev.core.imports.ImportPreferences;
import org.python.pydev.core.log.Log;
import org.python.pydev.shared_core.io.FileUtils;
import org.python.pydev.shared_core.string.FastStringBuffer;
import org.python.pydev.shared_core.string.StringUtils;
import org.python.pydev.shared_core.structure.Tuple;
import org.python.pydev.shared_core.structure.Tuple3;

public class ImportArranger {
    public boolean addNewLinesToImports = false;
    protected final IDocument doc;
    protected final String endLineDelim;
    private final String indentStr;
    private int lineForNewImports = -1;
    private final boolean multilineImports;
    private final boolean sortNamesGrouped;
    private int maxCols;
    private final boolean breakWithParenthesis;
    private final boolean removeUnusedImports;
    private final boolean automatic;
    protected final IPyFormatStdProvider edit;

    private static boolean getBreakImportsWithParenthesis(IPyFormatStdProvider edit) {
        String breakIportMode = ImportPreferences.getBreakImportMode((IAdaptable)edit);
        boolean breakWithParenthesis = true;
        if (!breakIportMode.equals("PARENTHESIS")) {
            breakWithParenthesis = false;
        }
        return breakWithParenthesis;
    }

    public ImportArranger(IDocument doc, boolean removeUnusedImports, String endLineDelim, String indentStr, boolean automatic, IPyFormatStdProvider edit, int maxCols) {
        this.doc = doc;
        this.endLineDelim = endLineDelim;
        this.indentStr = indentStr;
        this.removeUnusedImports = removeUnusedImports;
        this.automatic = automatic;
        this.edit = edit;
        this.maxCols = maxCols;
        this.multilineImports = ImportPreferences.getMultilineImports((IAdaptable)edit);
        this.sortNamesGrouped = ImportPreferences.getSortNamesGrouped((IAdaptable)edit);
        this.breakWithParenthesis = ImportArranger.getBreakImportsWithParenthesis(edit);
    }

    public void perform() {
        this.perform(ImportPreferences.getGroupImports((IAdaptable)this.edit), this.edit);
    }

    protected void perform(boolean groupFromImports, IPyFormatStdProvider edit) {
        boolean executeOnlyIfChanged = this.automatic;
        this.perform(groupFromImports, executeOnlyIfChanged, edit);
    }

    private void perform(boolean groupFromImports, boolean executeOnlyIfChanged, IPyFormatStdProvider edit) {
        List<Tuple3<Integer, String, ImportHandle>> list = this.collectImports();
        if (list.isEmpty()) {
            return;
        }
        int lineOfFirstOldImport = (Integer)list.get((int)0).o1;
        List<Tuple<Integer, String>> linesToDelete = this.deleteImports(list);
        if (!executeOnlyIfChanged) {
            for (Tuple<Integer, String> tup : linesToDelete) {
                PySelection.deleteLine((IDocument)this.doc, (int)((Integer)tup.o1));
            }
        }
        this.lineForNewImports = this.insertImportsHere(lineOfFirstOldImport);
        if (this.removeUnusedImports) {
            this.pruneEmptyImports(list);
        }
        this.sortImports(list);
        Object finalStr = this.createImportsStr(groupFromImports, list);
        if (executeOnlyIfChanged) {
            ArrayList<String> list2 = new ArrayList<String>();
            for (Tuple<Integer, String> tup : linesToDelete) {
                list2.add((String)tup.o2);
            }
            Collections.reverse(list2);
            String join = StringUtils.join((String)"", list2).trim();
            String other = StringUtils.replaceNewLines((String)finalStr, (String)"").trim();
            if (!join.equals(other)) {
                this.perform(groupFromImports, false, edit);
            }
            return;
        }
        try {
            FormatStd formatStd = (FormatStd)edit.getFormatStd();
            File editorFile = edit.getEditorFile();
            String filepath = null;
            if (editorFile != null) {
                filepath = FileUtils.getFileAbsolutePath((File)editorFile);
            }
            Document psDoc = new Document((String)finalStr);
            boolean isOpenedFile = false;
            boolean throwSyntaxError = false;
            PyFormatter.formatAll(filepath, (IDocument)psDoc, edit, isOpenedFile, formatStd, throwSyntaxError, true);
            finalStr = psDoc.get();
            if (this.addNewLinesToImports) {
                String expectedEnd = this.endLineDelim + this.endLineDelim + this.endLineDelim;
                while (!((String)finalStr).endsWith(expectedEnd)) {
                    finalStr = (String)finalStr + this.endLineDelim;
                }
            }
        }
        catch (Exception e) {
            Log.log((Throwable)e);
        }
        PySelection.addLine((IDocument)this.doc, (String)this.endLineDelim, (String)finalStr, (int)this.lineForNewImports);
    }

    private String createImportsStr(boolean groupFromImports, List<Tuple3<Integer, String, ImportHandle>> list) {
        FastStringBuffer all = new FastStringBuffer();
        if (!groupFromImports) {
            this.writeImports(list, all);
        } else {
            this.groupAndWriteImports(list, all);
        }
        String finalStr = all.toString();
        return finalStr;
    }

    private void pruneEmptyImports(List<Tuple3<Integer, String, ImportHandle>> list) {
        Iterator<Tuple3<Integer, String, ImportHandle>> it = list.iterator();
        while (it.hasNext()) {
            ImportHandle ih = (ImportHandle)it.next().o3;
            List info = ih.getImportInfo();
            Iterator itInfo = info.iterator();
            while (itInfo.hasNext()) {
                if (!((ImportHandle.ImportHandleInfo)itInfo.next()).getImportedStr().isEmpty()) continue;
                itInfo.remove();
            }
            if (info.size() != 0) continue;
            it.remove();
        }
    }

    protected void writeImports(List<Tuple3<Integer, String, ImportHandle>> list, FastStringBuffer all) {
        this.beforeImports(all);
        for (Tuple3<Integer, String, ImportHandle> element : list) {
            this.beforeImport(element, all);
            all.append((String)element.o2);
            all.append(this.endLineDelim);
        }
        this.afterImports(all);
    }

    protected void beforeImports(FastStringBuffer all) {
    }

    protected void afterImports(FastStringBuffer all) {
    }

    protected void beforeImport(Tuple3<Integer, String, ImportHandle> element, FastStringBuffer all) {
    }

    protected int insertImportsHere(int lineOfFirstOldImport) {
        return lineOfFirstOldImport - 1;
    }

    private void groupAndWriteImports(List<Tuple3<Integer, String, ImportHandle>> list, FastStringBuffer all) {
        TreeMap<String, FromImportEntries> importsWithFrom = new TreeMap<String, FromImportEntries>(new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                boolean isFuture2;
                Tuple splitted1 = StringUtils.splitOnFirst((String)o1, (char)'.');
                Tuple splitted2 = StringUtils.splitOnFirst((String)o2, (char)'.');
                boolean isFuture1 = ((String)splitted1.o1).equals("__future__");
                if (isFuture1 != (isFuture2 = ((String)splitted2.o1).equals("__future__"))) {
                    if (isFuture1) {
                        return -1;
                    }
                    return 1;
                }
                return o1.compareTo(o2);
            }
        });
        ArrayList<ImportHandle.ImportHandleInfo> importsWithoutFrom = new ArrayList<ImportHandle.ImportHandleInfo>();
        this.fillImportStructures(list, importsWithFrom, importsWithoutFrom);
        Set<Map.Entry<String, FromImportEntries>> entrySet = importsWithFrom.entrySet();
        for (Map.Entry<String, FromImportEntries> entry : entrySet) {
            FromImportEntries value = entry.getValue();
            value.setFrom(entry.getKey());
            value.checkForCommentsAfterImport();
            value.arrangeAndAdd(all);
        }
        this.writeImportsWithoutFrom(all, importsWithoutFrom);
    }

    private void fillImportStructures(List<Tuple3<Integer, String, ImportHandle>> list, TreeMap<String, FromImportEntries> importsWithFrom, List<ImportHandle.ImportHandleInfo> importsWithoutFrom) {
        for (Tuple3<Integer, String, ImportHandle> element : list) {
            List importInfo = ((ImportHandle)element.o3).getImportInfo();
            for (ImportHandle.ImportHandleInfo importHandleInfo : importInfo) {
                String fromImportStr = importHandleInfo.getFromImportStrWithoutUnwantedChars();
                if (fromImportStr == null) {
                    importsWithoutFrom.add(importHandleInfo);
                    continue;
                }
                FromImportEntries lst = importsWithFrom.get(fromImportStr);
                if (lst == null) {
                    lst = new FromImportEntries();
                    importsWithFrom.put(fromImportStr, lst);
                }
                lst.add(importHandleInfo);
            }
        }
    }

    protected void sortImports(List<Tuple3<Integer, String, ImportHandle>> list) {
        Collections.sort(list, new Comparator<Tuple3<Integer, String, ImportHandle>>(){

            @Override
            public int compare(Tuple3<Integer, String, ImportHandle> o1, Tuple3<Integer, String, ImportHandle> o2) {
                List info1 = ((ImportHandle)o1.o3).getImportInfo();
                List info2 = ((ImportHandle)o2.o3).getImportInfo();
                boolean isFuture1 = this.getIsFuture(info1);
                boolean isFuture2 = this.getIsFuture(info2);
                if (isFuture1 && !isFuture2) {
                    return -1;
                }
                if (!isFuture1 && isFuture2) {
                    return 1;
                }
                return ((String)o1.o2).compareTo((String)o2.o2);
            }

            private boolean getIsFuture(List<ImportHandle.ImportHandleInfo> info1) {
                String from1 = null;
                if (info1.size() > 0) {
                    from1 = info1.get(0).getFromImportStr();
                }
                boolean isFuture = from1 != null && from1.equals("__future__");
                return isFuture;
            }
        });
    }

    private List<Tuple<Integer, String>> deleteImports(List<Tuple3<Integer, String, ImportHandle>> list) {
        ArrayList<Tuple<Integer, String>> linesToDelete = new ArrayList<Tuple<Integer, String>>();
        Collections.sort(list, new Comparator<Tuple3<Integer, String, ImportHandle>>(){

            @Override
            public int compare(Tuple3<Integer, String, ImportHandle> o1, Tuple3<Integer, String, ImportHandle> o2) {
                return ((Integer)o2.o1).compareTo((Integer)o1.o1);
            }
        });
        for (Tuple3<Integer, String, ImportHandle> element : list) {
            String s = (String)element.o2;
            int max = StringUtils.countLineBreaks((String)s);
            int i = 0;
            while (i <= max) {
                int lineToDel = (Integer)element.o1;
                int j = lineToDel + i;
                linesToDelete.add((Tuple<Integer, String>)new Tuple((Object)j, (Object)PySelection.getLine((IDocument)this.doc, (int)j)));
                ++i;
            }
        }
        Comparator<Tuple<Integer, String>> c = new Comparator<Tuple<Integer, String>>(){

            @Override
            public int compare(Tuple<Integer, String> o1, Tuple<Integer, String> o2) {
                return Integer.compare((Integer)o2.o1, (Integer)o1.o1);
            }
        };
        Collections.sort(linesToDelete, c);
        return linesToDelete;
    }

    final List<Tuple3<Integer, String, ImportHandle>> collectImports() {
        ArrayList<Tuple3<Integer, String, ImportHandle>> list = new ArrayList<Tuple3<Integer, String, ImportHandle>>();
        PyImportsHandling pyImportsHandling = new PyImportsHandling(this.doc, true, this.removeUnusedImports);
        for (ImportHandle imp : pyImportsHandling) {
            if (imp.importFound.contains("@NoMove") || imp.importFound.contains("isort:skip")) continue;
            list.add((Tuple3<Integer, String, ImportHandle>)new Tuple3((Object)imp.startFoundLine, (Object)imp.importFound, (Object)imp));
        }
        return list;
    }

    private void writeImportsWithoutFrom(FastStringBuffer all, List<ImportHandle.ImportHandleInfo> importsWithoutFrom) {
        for (ImportHandle.ImportHandleInfo info : importsWithoutFrom) {
            List importedStr = info.getImportedStr();
            List commentsForImports = info.getCommentsForImports();
            int i = 0;
            while (i < importedStr.size()) {
                all.append("import ");
                String importedString = (String)importedStr.get(i);
                String comment = (String)commentsForImports.get(i);
                all.append(importedString);
                if (comment.length() > 0) {
                    all.append(' ');
                    all.append(comment);
                }
                all.append(this.endLineDelim);
                ++i;
            }
        }
    }

    private final class FromImportEntries {
        private final List<ImportHandle.ImportHandleInfo> containedImports = new ArrayList<ImportHandle.ImportHandleInfo>();
        private final List<Tuple<String, String>> importsAndComments = new ArrayList<Tuple<String, String>>();
        private final List<Tuple<String, String>> importsAndNoComments = new ArrayList<Tuple<String, String>>();
        private final FastStringBuffer lastFromXXXImportWritten = new FastStringBuffer();
        private final FastStringBuffer line = new FastStringBuffer();
        private String from;

        private FromImportEntries() {
        }

        public void add(ImportHandle.ImportHandleInfo info) {
            this.containedImports.add(info);
        }

        private void checkForCommentsAfterImport() {
            for (ImportHandle.ImportHandleInfo v : this.containedImports) {
                List importedStr = v.getImportedStr();
                List commentsForImports = v.getCommentsForImports();
                int i = 0;
                while (i < importedStr.size()) {
                    String importedString = ((String)importedStr.get(i)).trim();
                    String comment = ((String)commentsForImports.get(i)).trim();
                    boolean isWildImport = importedString.equals("*");
                    if (isWildImport) {
                        this.importsAndComments.clear();
                        this.importsAndNoComments.clear();
                    }
                    if (comment.length() > 0) {
                        this.importsAndComments.add((Tuple<String, String>)new Tuple((Object)importedString, (Object)comment));
                    } else {
                        this.importsAndNoComments.add((Tuple<String, String>)new Tuple((Object)importedString, (Object)comment));
                    }
                    if (isWildImport) {
                        return;
                    }
                    ++i;
                }
            }
        }

        public void setFrom(String from) {
            this.from = from;
        }

        public void arrangeAndAdd(FastStringBuffer all) {
            boolean firstInLine = true;
            this.line.clear();
            boolean addedParenForLine = false;
            this.importsAndNoComments.addAll(this.importsAndComments);
            if (ImportArranger.this.sortNamesGrouped) {
                Comparator<Tuple<String, String>> c = new Comparator<Tuple<String, String>>(){

                    @Override
                    public int compare(Tuple<String, String> o1, Tuple<String, String> o2) {
                        return ((String)o1.o1).compareTo((String)o2.o1);
                    }
                };
                Collections.sort(this.importsAndNoComments, c);
            }
            int i = 0;
            while (i < this.importsAndNoComments.size()) {
                Tuple<String, String> tuple = this.importsAndNoComments.get(i);
                if (firstInLine) {
                    this.lastFromXXXImportWritten.clear();
                    this.lastFromXXXImportWritten.append("from ");
                    this.lastFromXXXImportWritten.append(this.from);
                    this.lastFromXXXImportWritten.append(" import ");
                    this.line.append(this.lastFromXXXImportWritten);
                } else {
                    this.line.append(", ");
                }
                if (ImportArranger.this.multilineImports && this.line.length() + ((String)tuple.o1).length() + ((String)tuple.o2).length() > ImportArranger.this.maxCols) {
                    Object addAfter = ImportArranger.this.indentStr;
                    if (ImportArranger.this.breakWithParenthesis) {
                        if (!addedParenForLine) {
                            this.line.insert(this.lastFromXXXImportWritten.length(), '(');
                            if (StringUtils.rightTrim((String)this.line.toString()).length() > ImportArranger.this.maxCols) {
                                addAfter = ImportArranger.this.indentStr + this.line.subSequence(this.lastFromXXXImportWritten.length() + 1, this.line.length()).toString();
                                this.line.setLength(this.lastFromXXXImportWritten.length() + 1);
                            }
                            addedParenForLine = true;
                        }
                        this.line.append(ImportArranger.this.endLineDelim);
                    } else {
                        this.line.append('\\');
                        this.line.append(ImportArranger.this.endLineDelim);
                    }
                    all.append(this.line);
                    this.line.clear();
                    this.line.append((String)addAfter);
                }
                this.line.append((String)tuple.o1);
                if (addedParenForLine && i == this.importsAndNoComments.size()) {
                    addedParenForLine = false;
                    this.line.append(')');
                }
                firstInLine = false;
                if (((String)tuple.o2).length() > 0) {
                    if (addedParenForLine) {
                        addedParenForLine = false;
                        this.line.append(')');
                    }
                    this.line.append(' ');
                    this.line.append((String)tuple.o2);
                    this.line.append(ImportArranger.this.endLineDelim);
                    all.append(this.line);
                    this.line.clear();
                    firstInLine = true;
                }
                ++i;
            }
            if (!firstInLine) {
                if (addedParenForLine) {
                    addedParenForLine = false;
                    this.line.append(')');
                }
                this.line.append(ImportArranger.this.endLineDelim);
                all.append(this.line);
                this.line.clear();
            }
        }
    }
}

