/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.core.pep8;

import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.text.IDocument;
import org.python.pydev.ast.interpreter_managers.InterpreterManagersAPI;
import org.python.pydev.ast.runners.SimplePythonRunner;
import org.python.pydev.core.CorePlugin;
import org.python.pydev.core.IInterpreterInfo;
import org.python.pydev.core.IInterpreterManager;
import org.python.pydev.core.MisconfigurationException;
import org.python.pydev.core.log.Log;
import org.python.pydev.plugin.nature.SystemPythonNature;
import org.python.pydev.shared_core.callbacks.ICallback;
import org.python.pydev.shared_core.io.FileUtils;
import org.python.pydev.shared_core.process.ProcessUtils;
import org.python.pydev.shared_core.structure.Tuple;

public class Pep8Runner {
    public static String runWithPep8BaseScript(IDocument doc, String parameters, String script) {
        IInterpreterInfo defaultInterpreterInfo;
        File autopep8File;
        try {
            autopep8File = CorePlugin.getScriptWithinPySrc((String)new Path("third_party").append("pep8").append(script).toString());
        }
        catch (CoreException e) {
            Log.log((String)("Unable to get " + script + " location."));
            return null;
        }
        if (!autopep8File.exists()) {
            Log.log((String)("Specified location for " + script + " does not exist (" + String.valueOf(autopep8File) + ")."));
            return null;
        }
        SimplePythonRunner simplePythonRunner = new SimplePythonRunner();
        IInterpreterManager pythonInterpreterManager = InterpreterManagersAPI.getPythonInterpreterManager();
        try {
            defaultInterpreterInfo = pythonInterpreterManager.getDefaultInterpreterInfo(false);
        }
        catch (MisconfigurationException e) {
            Log.log((String)("No default Python interpreter configured to run " + script));
            return null;
        }
        String[] parseArguments = ProcessUtils.parseArguments((String)parameters);
        ArrayList<String> lst = new ArrayList<String>(Arrays.asList(parseArguments));
        lst.add("-");
        String[] cmdarray = SimplePythonRunner.preparePythonCallParameters(defaultInterpreterInfo.getExecutableOrJar(), autopep8File.toString(), lst.toArray(new String[0]));
        String pythonFileEncoding = null;
        try {
            pythonFileEncoding = FileUtils.getPythonFileEncoding((IDocument)doc, null);
            if (pythonFileEncoding == null) {
                pythonFileEncoding = "utf-8";
            }
        }
        catch (UnsupportedEncodingException e) {
            pythonFileEncoding = "utf-8";
        }
        final String encodingUsed = pythonFileEncoding;
        SystemPythonNature nature = new SystemPythonNature(pythonInterpreterManager, defaultInterpreterInfo);
        ICallback<String[], String[]> updateEnv = new ICallback<String[], String[]>(){

            public String[] call(String[] arg) {
                arg = arg == null ? new String[]{"PYTHONIOENCODING=" + encodingUsed} : ProcessUtils.addOrReplaceEnvVar((String[])arg, (String)"PYTHONIOENCODING", (String)encodingUsed);
                return arg;
            }
        };
        Tuple<Process, String> r = simplePythonRunner.run(cmdarray, autopep8File.getParentFile(), nature, (IProgressMonitor)new NullProgressMonitor(), updateEnv);
        try {
            ((Process)r.o1).getOutputStream().write(doc.get().getBytes(pythonFileEncoding));
            ((Process)r.o1).getOutputStream().close();
        }
        catch (IOException e) {
            Log.log((String)("Error writing contents to " + script));
            return null;
        }
        Tuple<String, String> processOutput = SimplePythonRunner.getProcessOutput((Process)r.o1, (String)r.o2, (IProgressMonitor)new NullProgressMonitor(), pythonFileEncoding);
        if (((String)processOutput.o2).length() > 0) {
            Log.log((String)((String)processOutput.o2));
        }
        if (((String)processOutput.o1).length() > 0) {
            return (String)processOutput.o1;
        }
        return null;
    }
}

