/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.core.pep8;

import java.io.File;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.text.IDocument;
import org.python.pydev.ast.interpreter_managers.InterpreterManagersAPI;
import org.python.pydev.ast.runners.SimpleRunner;
import org.python.pydev.ast.runners.UniversalRunner;
import org.python.pydev.core.IInterpreterManager;
import org.python.pydev.core.IPythonNature;
import org.python.pydev.core.MisconfigurationException;
import org.python.pydev.core.formatter.FormatStd;
import org.python.pydev.core.log.Log;
import org.python.pydev.core.pep8.RunnerCommon;
import org.python.pydev.plugin.nature.SystemPythonNature;
import org.python.pydev.shared_core.io.FileUtils;
import org.python.pydev.shared_core.process.ProcessUtils;
import org.python.pydev.shared_core.structure.Tuple;
import org.python.pydev.shared_core.utils.ArrayUtils;

public class RuffRunner {
    public static String formatWithRuff(String filepath, IPythonNature nature, IDocument doc, FormatStd std, File workingDir) {
        try {
            String cmdarrayAsStr;
            Process process;
            String[] stringArray;
            String[] parseArguments = ProcessUtils.parseArguments((String)std.ruffParameters);
            if (filepath != null && filepath.length() > 0) {
                String[] stringArray2 = new String[2];
                stringArray2[0] = "--stdin-filename";
                stringArray = stringArray2;
                stringArray2[1] = filepath;
            } else {
                stringArray = new String[]{};
            }
            String[] pathArgs = stringArray;
            String executableLocation = std.ruffExecutableLocation;
            if (!std.searchRuffInInterpreter && executableLocation != null && !executableLocation.isEmpty() && FileUtils.enhancedIsFile((File)new File(executableLocation))) {
                SimpleRunner simpleRunner = new SimpleRunner();
                String[] args = (String[])ArrayUtils.concatArrays((Object[][])new String[][]{{executableLocation, "format", "-"}, pathArgs, parseArguments});
                Tuple<Process, String> r = simpleRunner.run(args, workingDir, null, null);
                process = (Process)r.o1;
                cmdarrayAsStr = (String)r.o2;
            } else {
                if (nature == null) {
                    IInterpreterManager manager = InterpreterManagersAPI.getPythonInterpreterManager();
                    try {
                        nature = new SystemPythonNature(manager);
                    }
                    catch (MisconfigurationException e) {
                        Log.log((Throwable)e);
                    }
                }
                UniversalRunner.PythonRunner pythonRunner = new UniversalRunner.PythonRunner(nature);
                Tuple<Process, String> processInfo = pythonRunner.createProcessFromModuleName("ruff", (String[])ArrayUtils.concatArrays((Object[][])new String[][]{{"format", "-"}, pathArgs, parseArguments}), workingDir, (IProgressMonitor)new NullProgressMonitor());
                process = (Process)processInfo.o1;
                cmdarrayAsStr = (String)processInfo.o2;
            }
            String pythonFileEncoding = FileUtils.getPythonFileEncoding((IDocument)doc, null);
            if (pythonFileEncoding == null) {
                pythonFileEncoding = "utf-8";
            }
            return RunnerCommon.writeContentsAndGetOutput(doc.get().getBytes(pythonFileEncoding), pythonFileEncoding, process, cmdarrayAsStr, "ruff");
        }
        catch (Exception e) {
            Log.log((Throwable)e);
            return null;
        }
    }
}

