/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.core.templates;

import java.io.File;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.templates.GlobalTemplateVariables;
import org.eclipse.jface.text.templates.TemplateContextType;
import org.eclipse.jface.text.templates.TemplateVariableResolver;
import org.python.pydev.core.IIndentPrefs;
import org.python.pydev.core.IInterpreterInfo;
import org.python.pydev.core.IPyEdit;
import org.python.pydev.core.IPySourceViewer;
import org.python.pydev.core.IPythonNature;
import org.python.pydev.core.ISourceViewerForTemplates;
import org.python.pydev.core.MisconfigurationException;
import org.python.pydev.core.autoedit.DefaultIndentPrefs;
import org.python.pydev.core.docutils.PySelection;
import org.python.pydev.core.interactive_console.IScriptConsoleViewer;
import org.python.pydev.core.templates.DocumentTemplateContextWithIndent;
import org.python.pydev.core.templates.PyAddTemplateResolvers;
import org.python.pydev.parser.fastparser.FastParser;
import org.python.pydev.parser.jython.ast.ClassDef;
import org.python.pydev.parser.jython.ast.FunctionDef;
import org.python.pydev.parser.visitors.NodeUtils;
import org.python.pydev.shared_core.string.ICoreTextSelection;

public final class PyDocumentTemplateContext
extends DocumentTemplateContextWithIndent {
    public ISourceViewerForTemplates edit;

    public PyDocumentTemplateContext(TemplateContextType type, IDocument document, int offset, int length, String indentTo, IIndentPrefs indentPrefs) {
        super(type, document, offset, length, indentTo, indentPrefs);
    }

    public PyDocumentTemplateContext(TemplateContextType type, IDocument document, int offset, int length, String indentTo, ISourceViewerForTemplates viewer) {
        this(type, document, offset, length, indentTo, viewer != null ? viewer.getIndentPrefs() : DefaultIndentPrefs.get(null));
        this.edit = viewer;
    }

    public PySelection createPySelection() {
        return new PySelection(this.getDocument(), this.getStart());
    }

    public Class<FastParser> getFastParserClass() {
        return FastParser.class;
    }

    public Class<NodeUtils> getNodeUtilsClass() {
        return NodeUtils.class;
    }

    public Class<FunctionDef> getFunctionDefClass() {
        return FunctionDef.class;
    }

    public Class<ClassDef> getClassDefClass() {
        return ClassDef.class;
    }

    public Class<BadLocationException> getBadLocationExceptionClass() {
        return BadLocationException.class;
    }

    public boolean isCythonFile() {
        if (this.edit != null) {
            return this.edit.isCythonFile();
        }
        return false;
    }

    public File getEditorFile() {
        if (this.edit != null) {
            return this.edit.getEditorFile();
        }
        return new File("");
    }

    public int getGrammarVersion() {
        IScriptConsoleViewer v;
        IInterpreterInfo interpreterInfo;
        if (this.edit instanceof IPySourceViewer) {
            try {
                IPythonNature nature = ((IPySourceViewer)this.edit).getEdit().getPythonNature();
                if (nature != null) {
                    return nature.getGrammarVersion();
                }
            }
            catch (MisconfigurationException nature) {
                // empty catch block
            }
        }
        if (this.edit instanceof IScriptConsoleViewer && (interpreterInfo = (IInterpreterInfo)(v = (IScriptConsoleViewer)this.edit).getInterpreterInfo()) != null) {
            return interpreterInfo.getGrammarVersion();
        }
        return 107;
    }

    public String getModuleName() {
        if (this.edit instanceof IPySourceViewer) {
            try {
                IPySourceViewer pyViewer = (IPySourceViewer)this.edit;
                IPyEdit edit = pyViewer.getEdit();
                IPythonNature nature = edit.getPythonNature();
                if (nature != null) {
                    return nature.resolveModule(edit.getEditorFile());
                }
            }
            catch (MisconfigurationException misconfigurationException) {
                // empty catch block
            }
        }
        return "";
    }

    public static PyDocumentTemplateContext createContext(TemplateContextType contextType, ISourceViewerForTemplates edit, IDocument document, IRegion region, String indentTo) {
        if (contextType != null) {
            return new PyDocumentTemplateContext(contextType, document, region.getOffset(), region.getLength(), indentTo, edit);
        }
        return null;
    }

    public static PyDocumentTemplateContext createContext(TemplateContextType contextType, ISourceViewerForTemplates edit, IRegion region) {
        if (contextType != null) {
            IDocument document = edit.getDocument();
            ICoreTextSelection textSelection = edit.getTextSelection();
            PySelection selection = new PySelection(document, textSelection);
            String indent = selection.getIndentationFromLine();
            return PyDocumentTemplateContext.createContext(contextType, edit, edit.getDocument(), region, indent);
        }
        return null;
    }

    public static PyDocumentTemplateContext createContextWithCursor(ISourceViewerForTemplates targetEditor, IRegion region, String indent) {
        TemplateContextType contextType = new TemplateContextType();
        contextType.addResolver((TemplateVariableResolver)new GlobalTemplateVariables.Cursor());
        return PyDocumentTemplateContext.createContext(contextType, targetEditor, targetEditor != null ? targetEditor.getDocument() : null, region, indent);
    }

    public static PyDocumentTemplateContext createContextWithCursor(ISourceViewerForTemplates targetEditor, IDocument document, IRegion region, String indent) {
        TemplateContextType contextType = new TemplateContextType();
        contextType.addResolver((TemplateVariableResolver)new GlobalTemplateVariables.Cursor());
        return PyDocumentTemplateContext.createContext(contextType, targetEditor, document, region, indent);
    }

    public static PyDocumentTemplateContext createContextWithDefaultResolvers(ISourceViewerForTemplates edit, IRegion region, String indentTo) {
        TemplateContextType contextType = new TemplateContextType();
        PyAddTemplateResolvers.addDefaultResolvers(contextType);
        return PyDocumentTemplateContext.createContext(contextType, edit, edit != null ? edit.getDocument() : null, region, indentTo);
    }
}

