/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.plugin.nature;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.python.pydev.ast.interpreter_managers.InterpreterInfo;
import org.python.pydev.ast.runners.SimpleExeRunner;
import org.python.pydev.core.IInterpreterInfo;
import org.python.pydev.core.IInterpreterManager;
import org.python.pydev.core.preferences.PydevPrefs;
import org.python.pydev.plugin.nature.PythonNature;
import org.python.pydev.shared_core.io.FileUtils;
import org.python.pydev.shared_core.structure.Tuple;
import org.python.pydev.shared_core.utils.PlatformUtils;

public class PipenvHelper {
    private static String computedPipEnvLocation = null;
    private static Object projectLocationToPipenvPythonLocationChacheLock = new Object();
    private static Map<File, Optional<File>> projectLocationToPipenvPythonLocationChache = new HashMap<File, Optional<File>>();

    public static IInterpreterInfo getPipenvInterpreterInfoForProjectLocation(IInterpreterInfo[] interpretersInfo, File projectlocation, IInterpreterManager interpreterManager) {
        String pipenvLocation;
        IInterpreterInfo info = PipenvHelper.getInterpreterInfoWithTargetDir(interpretersInfo, projectlocation);
        if (info != null) {
            return info;
        }
        if (projectlocation.exists() && new File(projectlocation, "Pipfile").exists() && (pipenvLocation = PipenvHelper.searchDefaultPipenvLocation(interpretersInfo[0], interpreterManager)) != null) {
            File pythonVenvFromLocation = PipenvHelper.getPythonExecutableFromProjectLocationWithPipenv(pipenvLocation, projectlocation);
            IInterpreterInfo[] iInterpreterInfoArray = interpretersInfo;
            int n = interpretersInfo.length;
            int n2 = 0;
            while (n2 < n) {
                IInterpreterInfo tempInfo = iInterpreterInfoArray[n2];
                if (new File(tempInfo.getExecutableOrJar()).equals(pythonVenvFromLocation)) {
                    return tempInfo;
                }
                ++n2;
            }
        }
        return null;
    }

    public static IInterpreterInfo getInterpreterInfoWithTargetDir(IInterpreterInfo[] interpretersInfo, File pipenvTargetDir) {
        IInterpreterInfo[] iInterpreterInfoArray = interpretersInfo;
        int n = interpretersInfo.length;
        int n2 = 0;
        while (n2 < n) {
            IInterpreterInfo info = iInterpreterInfoArray[n2];
            if (info.getPipenvTargetDir() != null && new File(info.getPipenvTargetDir()).equals(pipenvTargetDir)) {
                return info;
            }
            ++n2;
        }
        return null;
    }

    public static String searchDefaultPipenvLocation(IInterpreterInfo interpreterInfo, IInterpreterManager interpreterManager) {
        String ret = PydevPrefs.getEclipsePreferences().get("DEFAULT_PIPENV_LOCATION", "");
        if (!ret.trim().isEmpty()) {
            return ret;
        }
        if (interpreterInfo != null) {
            String computed = interpreterInfo.getComputedPipEnvLocation();
            if (computed == null) {
                interpreterInfo.setComputedPipEnvLocation(PipenvHelper.computePipEnvLocation(interpreterInfo, interpreterManager));
            }
            return interpreterInfo.getComputedPipEnvLocation();
        }
        if (computedPipEnvLocation == null) {
            computedPipEnvLocation = PipenvHelper.computePipEnvLocation(interpreterInfo, interpreterManager);
        }
        return computedPipEnvLocation;
    }

    private static String computePipEnvLocation(IInterpreterInfo interpreterInfo, IInterpreterManager interpreterManager) {
        Set<String> pathsToSearch = PythonNature.getPathsToSearch();
        ArrayList<File> searchedDirectories = new ArrayList<File>();
        for (String string : pathsToSearch) {
            File file = InterpreterInfo.searchExecutableInContainer("pipenv", new File(string), searchedDirectories);
            if (file == null) continue;
            return file.getAbsolutePath();
        }
        if (interpreterInfo != null) {
            File f;
            String executableOrJar = interpreterInfo.getExecutableOrJar();
            File file = InterpreterInfo.searchExecutableInContainer("pipenv", new File(executableOrJar).getParentFile(), searchedDirectories);
            if (file != null) {
                return file.getAbsolutePath();
            }
            String userInfo = interpreterInfo.obtainUserSitePackages(interpreterManager);
            if (!userInfo.isEmpty() && (f = new File(userInfo)).exists()) {
                if (PlatformUtils.isWindowsPlatform()) {
                    f = f.getParentFile();
                }
                if ((file = InterpreterInfo.searchExecutableInContainer("pipenv", f, searchedDirectories)) != null) {
                    return file.getAbsolutePath();
                }
            }
        }
        return null;
    }

    public static void storeDefaultPipenvLocation(String pipenvLocation) {
        PydevPrefs.getEclipsePreferences().put("DEFAULT_PIPENV_LOCATION", pipenvLocation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static File getPythonExecutableFromProjectLocationWithPipenv(String pipenvLocation, File projectlocation) {
        ArrayList<File> searchedDirectories;
        File pythonExecutable;
        File venvLocation;
        Object object = projectLocationToPipenvPythonLocationChacheLock;
        synchronized (object) {
            Optional<File> pipenvPythonLocation = projectLocationToPipenvPythonLocationChache.get(projectlocation);
            if (pipenvPythonLocation != null) {
                if (!pipenvPythonLocation.isPresent()) return null;
                return pipenvPythonLocation.get();
            }
        }
        SimpleExeRunner runner = new SimpleExeRunner();
        Tuple<Process, String> processInfo = runner.run(new String[]{pipenvLocation, "--venv"}, projectlocation, null, null);
        Tuple<String, String> processOutput = SimpleExeRunner.getProcessOutput((Process)processInfo.o1, (String)processInfo.o2, null, "utf-8");
        if (((Process)processInfo.o1).exitValue() == 0 && (venvLocation = new File(((String)processOutput.o1).trim())).exists() && (pythonExecutable = InterpreterInfo.searchExecutableInContainer("python", venvLocation, searchedDirectories = new ArrayList<File>())) != null && FileUtils.enhancedIsFile((File)pythonExecutable)) {
            Object object2 = projectLocationToPipenvPythonLocationChacheLock;
            synchronized (object2) {
                projectLocationToPipenvPythonLocationChache.put(projectlocation, Optional.of(pythonExecutable));
                return pythonExecutable;
            }
        }
        Object object3 = projectLocationToPipenvPythonLocationChacheLock;
        synchronized (object3) {
            projectLocationToPipenvPythonLocationChache.put(projectlocation, Optional.empty());
            return null;
        }
    }
}

