package org.python.pydev.editor.codecompletion;

import java.util.List;

import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateCompletionProcessor;
import org.eclipse.jface.text.templates.TemplateContext;
import org.eclipse.jface.text.templates.TemplateContextType;
import org.eclipse.swt.graphics.Image;
import org.python.pydev.core.ISourceViewerForTemplates;
import org.python.pydev.core.log.Log;
import org.python.pydev.core.proposals.CompletionProposalFactory;
import org.python.pydev.core.templates.PyDocumentTemplateContext;
import org.python.pydev.editor.templates.PyContextType;
import org.python.pydev.editor.templates.TemplateHelper;
import org.python.pydev.shared_core.code_completion.ICompletionProposalHandle;
import org.python.pydev.shared_core.image.IImageHandle;
import org.python.pydev.shared_core.image.UIConstants;
import org.python.pydev.shared_ui.ImageCache;
import org.python.pydev.shared_ui.SharedUiPlugin;

/**
 * @author Fabio Zadrozny
 */
public class PyTemplateCompletionProcessor extends TemplateCompletionProcessor
        implements IPyTemplateCompletionProcessor {

    private String currentContext;

    /*
     * (non-Javadoc)
     *
     * @see org.eclipse.jface.text.templates.TemplateCompletionProcessor#getTemplates(java.lang.String)
     */
    @Override
    protected Template[] getTemplates(String contextTypeId) {
        return TemplateHelper.getTemplateStore().getTemplates();
    }

    /*
     * (non-Javadoc)
     *
     * @see org.eclipse.jface.text.templates.TemplateCompletionProcessor#getContextType(org.eclipse.jface.text.ITextViewer,
     *      org.eclipse.jface.text.IRegion)
     */
    @Override
    protected TemplateContextType getContextType(ITextViewer viewer, IRegion region) {
        return TemplateHelper.getContextTypeRegistry().getContextType(this.currentContext);
    }

    /*
     * (non-Javadoc)
     *
     * @see org.eclipse.jface.text.templates.TemplateCompletionProcessor#getImage(org.eclipse.jface.text.templates.Template)
     */
    @Override
    protected Image getImage(Template template) {
        return ImageCache.asImage(getImageHandle());
    }

    private IImageHandle getImageHandle() {
        return SharedUiPlugin.getImageCache().get(UIConstants.COMPLETION_TEMPLATE);
    }

    /**
     * @param viewer
     * @param documentOffset
     * @param propList
     *
     */
    @Override
    public void addTemplateProposals(ITextViewer viewer, int documentOffset, List<ICompletionProposalHandle> propList) {
        IDocument doc = viewer.getDocument();
        if (doc.getLength() == 0) {
            this.currentContext = PyContextType.PY_MODULES_CONTEXT_TYPE;

        } else {
            this.currentContext = PyContextType.PY_COMPLETIONS_CONTEXT_TYPE;

        }

        String str = extractPrefix(viewer, documentOffset);

        ICompletionProposal[] templateProposals = computeCompletionProposals(viewer, documentOffset);

        for (int j = 0; j < templateProposals.length; j++) {
            if (templateProposals[j].getDisplayString().startsWith(str)) {
                propList.add((ICompletionProposalHandle) templateProposals[j]);
            }
        }
    }

    @Override
    protected ICompletionProposal createProposal(Template template, TemplateContext context, IRegion region,
            int relevance) {
        return (ICompletionProposal) CompletionProposalFactory.get().createPyTemplateProposal(
                template, context, region, getImageHandle(), relevance);
    }

    /**
     * Overridden so that we can do the indentation in this case.
     */
    @Override
    protected TemplateContext createContext(final ITextViewer viewer, final IRegion region) {
        TemplateContextType contextType = getContextType(viewer, region);
        if (viewer instanceof ISourceViewerForTemplates) {
            ISourceViewerForTemplates pySourceViewer = (ISourceViewerForTemplates) viewer;

            return PyDocumentTemplateContext.createContext(contextType, pySourceViewer, region);
        }
        Log.log("Expected an ISourceViewerForTemplates. Found: " + viewer);
        return PyDocumentTemplateContext.createContext(contextType, null, region);

    }

}
