/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.cview;

import java.util.ArrayList;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.IArchive;
import org.eclipse.cdt.core.model.IArchiveContainer;
import org.eclipse.cdt.core.model.IBinary;
import org.eclipse.cdt.core.model.IBinaryContainer;
import org.eclipse.cdt.core.model.IBinaryModule;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICModel;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.IParent;
import org.eclipse.cdt.core.model.ISourceReference;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.internal.ui.actions.SelectionConverter;
import org.eclipse.cdt.internal.ui.cview.CViewActionGroup;
import org.eclipse.cdt.internal.ui.cview.CViewContentProvider;
import org.eclipse.cdt.internal.ui.cview.CViewElementComparer;
import org.eclipse.cdt.internal.ui.cview.CViewFrameSource;
import org.eclipse.cdt.internal.ui.cview.CViewLabelProvider;
import org.eclipse.cdt.internal.ui.cview.CViewMessages;
import org.eclipse.cdt.internal.ui.cview.MainActionGroup;
import org.eclipse.cdt.internal.ui.cview.SelectionTransferDragAdapter;
import org.eclipse.cdt.internal.ui.cview.SelectionTransferDropAdapter;
import org.eclipse.cdt.internal.ui.dnd.CDTViewerDragAdapter;
import org.eclipse.cdt.internal.ui.dnd.DelegatingDropAdapter;
import org.eclipse.cdt.internal.ui.dnd.FileTransferDragAdapter;
import org.eclipse.cdt.internal.ui.dnd.FileTransferDropAdapter;
import org.eclipse.cdt.internal.ui.dnd.PluginTransferDropAdapter;
import org.eclipse.cdt.internal.ui.dnd.ResourceTransferDragAdapter;
import org.eclipse.cdt.internal.ui.dnd.ResourceTransferDropAdapter;
import org.eclipse.cdt.internal.ui.dnd.TransferDragSourceListener;
import org.eclipse.cdt.internal.ui.dnd.TransferDropTargetListener;
import org.eclipse.cdt.internal.ui.editor.ITranslationUnitEditorInput;
import org.eclipse.cdt.internal.ui.preferences.CPluginPreferencePage;
import org.eclipse.cdt.internal.ui.util.EditorUtility;
import org.eclipse.cdt.internal.ui.util.ProblemTreeViewer;
import org.eclipse.cdt.internal.ui.util.RemoteTreeViewer;
import org.eclipse.cdt.internal.ui.viewsupport.CUILabelProvider;
import org.eclipse.cdt.internal.ui.viewsupport.DecoratingCLabelProvider;
import org.eclipse.cdt.ui.CElementContentProvider;
import org.eclipse.cdt.ui.CElementSorter;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.cdt.ui.PreferenceConstants;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.IWorkingSetManager;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ResourceWorkingSetFilter;
import org.eclipse.ui.actions.ActionContext;
import org.eclipse.ui.contexts.IContextActivation;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.model.IWorkbenchAdapter;
import org.eclipse.ui.part.ISetSelectionTarget;
import org.eclipse.ui.part.IShowInSource;
import org.eclipse.ui.part.IShowInTarget;
import org.eclipse.ui.part.IShowInTargetList;
import org.eclipse.ui.part.PluginTransfer;
import org.eclipse.ui.part.ResourceTransfer;
import org.eclipse.ui.part.ShowInContext;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.views.framelist.FrameList;
import org.eclipse.ui.views.framelist.IFrameSource;

public class CView
extends ViewPart
implements ISetSelectionTarget,
IPropertyChangeListener,
IShowInTarget,
IShowInTargetList {
    ProblemTreeViewer viewer;
    IMemento memento;
    CViewActionGroup actionGroup;
    FrameList frameList;
    CViewFrameSource frameSource;
    ResourceWorkingSetFilter workingSetFilter = new ResourceWorkingSetFilter();
    protected boolean dragDetected;
    private Listener dragDetectListener;
    static final String TAG_SELECTION = "selection";
    static final String TAG_EXPANDED = "expanded";
    static final String TAG_ELEMENT = "element";
    static final String TAG_PATH = "path";
    static final String TAG_VERTICAL_POSITION = "verticalPosition";
    static final String TAG_HORIZONTAL_POSITION = "horizontalPosition";
    static final String TAG_WORKINGSET = "workingSet";
    final String WORKING_GROUP_MARKER = "workingSetGroup";
    final String WORKING_GROUP_MARKER_END = "end-workingSetGroup";
    private IPartListener partListener = new IPartListener(){

        public void partActivated(IWorkbenchPart part) {
            if (part instanceof IEditorPart) {
                CView.this.editorActivated((IEditorPart)part);
            }
        }

        public void partBroughtToTop(IWorkbenchPart part) {
        }

        public void partClosed(IWorkbenchPart part) {
        }

        public void partDeactivated(IWorkbenchPart part) {
        }

        public void partOpened(IWorkbenchPart part) {
        }
    };
    private IPropertyChangeListener workingSetListener = ev -> {
        String property = ev.getProperty();
        Object newValue = ev.getNewValue();
        Object oldValue = ev.getOldValue();
        IWorkingSet filterWorkingSet = this.workingSetFilter.getWorkingSet();
        if (property == null) {
            return;
        }
        if ("workingSetRemove".equals(property) && oldValue == filterWorkingSet) {
            this.setWorkingSet(null);
        } else if ("workingSetNameChange".equals(property) && newValue == filterWorkingSet) {
            this.updateTitle();
        } else if ("workingSetContentChange".equals(property) && newValue == filterWorkingSet) {
            this.getViewer().refresh();
        }
    };
    private IContextActivation fContextActivation;

    public void setFocus() {
        this.viewer.getTree().setFocus();
    }

    public void selectReveal(ISelection selection) {
        IStructuredSelection ssel = SelectionConverter.convertSelectionToCElements(selection, true);
        if (!ssel.isEmpty()) {
            this.getViewer().setSelection((ISelection)ssel, true);
        }
    }

    protected void handleOpen(OpenEvent event) {
        IStructuredSelection selection = (IStructuredSelection)event.getSelection();
        this.getActionGroup().runDefaultAction(selection);
    }

    protected void handleDoubleClick(DoubleClickEvent event) {
        IStructuredSelection s = (IStructuredSelection)event.getSelection();
        Object o = s.getFirstElement();
        if (this.viewer.isExpandable(o)) {
            if (o instanceof ITranslationUnit || o instanceof IBinary || o instanceof IArchive) {
                return;
            }
            this.viewer.setExpandedState(o, !this.viewer.getExpandedState(o));
        }
    }

    void handleKeyPressed(KeyEvent event) {
        if (this.getActionGroup() != null) {
            this.getActionGroup().handleKeyPressed(event);
        }
    }

    protected void handleKeyReleased(KeyEvent event) {
        if (this.getActionGroup() != null) {
            this.getActionGroup().handleKeyReleased(event);
        }
    }

    void handleSelectionChanged(SelectionChangedEvent event) {
        IStructuredSelection selection = (IStructuredSelection)event.getSelection();
        this.updateStatusLine(selection);
        this.updateActionBars(selection);
        this.dragDetected = false;
        if (this.isLinkingEnabled()) {
            this.getSite().getShell().getDisplay().asyncExec(() -> {
                if (!this.dragDetected) {
                    this.linkToEditor(selection);
                }
            });
        }
    }

    protected CViewActionGroup getActionGroup() {
        return this.actionGroup;
    }

    protected void setActionGroup(CViewActionGroup actionGroup) {
        this.actionGroup = actionGroup;
    }

    public <T> T getAdapter(Class<T> key) {
        if (key.equals(ISelectionProvider.class)) {
            return (T)((Object)this.viewer);
        }
        if (key == IShowInSource.class) {
            return (T)this.getShowInSource();
        }
        if (key == IShowInTarget.class) {
            return (T)((Object)this);
        }
        return (T)super.getAdapter(key);
    }

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        super.init(site, memento);
        this.memento = memento;
    }

    void initFrameList() {
        this.frameSource = new CViewFrameSource(this);
        this.frameList = new FrameList((IFrameSource)this.frameSource);
        this.frameSource.connectTo(this.frameList);
    }

    void initCElementSorter() {
        this.viewer.setComparator((ViewerComparator)new CElementSorter());
    }

    void initFilters(TreeViewer viewer) {
        viewer.addFilter((ViewerFilter)this.workingSetFilter);
    }

    void initDragAndDrop() {
        this.initDrag();
        this.initDrop();
        this.dragDetectListener = event -> {
            boolean bl = this.dragDetected = true;
        };
        this.viewer.getControl().addListener(29, this.dragDetectListener);
    }

    private void initDrag() {
        int ops = 7;
        Transfer[] transfers = new Transfer[]{LocalSelectionTransfer.getTransfer(), ResourceTransfer.getInstance(), FileTransfer.getInstance()};
        TransferDragSourceListener[] dragListeners = new TransferDragSourceListener[]{new SelectionTransferDragAdapter((ISelectionProvider)this.viewer), new ResourceTransferDragAdapter((ISelectionProvider)this.viewer), new FileTransferDragAdapter((ISelectionProvider)this.viewer)};
        this.viewer.addDragSupport(ops, transfers, new CDTViewerDragAdapter((StructuredViewer)this.viewer, dragListeners));
    }

    private void initDrop() {
        int ops = 23;
        Transfer[] transfers = new Transfer[]{LocalSelectionTransfer.getTransfer(), ResourceTransfer.getInstance(), FileTransfer.getInstance(), PluginTransfer.getInstance()};
        TransferDropTargetListener[] dropListeners = new TransferDropTargetListener[]{new SelectionTransferDropAdapter((StructuredViewer)this.viewer), new ResourceTransferDropAdapter((StructuredViewer)this.viewer), new FileTransferDropAdapter((AbstractTreeViewer)this.viewer), new PluginTransferDropAdapter((StructuredViewer)this.viewer)};
        this.viewer.addDropSupport(ops, transfers, new DelegatingDropAdapter(dropListeners));
    }

    public static void initDefaults(IPreferenceStore store) {
    }

    void initFilterFromPreferences() {
    }

    void initContentProvider(TreeViewer viewer) {
        IContentProvider provider = this.createContentProvider();
        viewer.setContentProvider(provider);
    }

    void initLabelProvider(TreeViewer viewer) {
        CUILabelProvider cProvider = this.createLabelProvider();
        viewer.setLabelProvider((IBaseLabelProvider)new DecoratingCLabelProvider(cProvider, true));
    }

    protected void initContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(manager -> this.fillContextMenu(manager));
        TreeViewer viewer = this.getViewer();
        Menu menu = menuMgr.createContextMenu((Control)viewer.getTree());
        viewer.getTree().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)viewer);
    }

    void initWorkingSetFilter() {
        IWorkingSetManager wsmanager;
        IWorkingSet workingSet;
        if (this.memento == null) {
            return;
        }
        String wsname = this.memento.getString(TAG_WORKINGSET);
        if (wsname != null && !wsname.isEmpty() && (workingSet = (wsmanager = this.getViewSite().getWorkbenchWindow().getWorkbench().getWorkingSetManager()).getWorkingSet(wsname)) != null) {
            this.workingSetFilter.setWorkingSet(workingSet);
        }
    }

    protected void initListeners(TreeViewer viewer) {
        viewer.addDoubleClickListener(event -> this.handleDoubleClick(event));
        viewer.addSelectionChangedListener(event -> this.handleSelectionChanged(event));
        viewer.addOpenListener(event -> this.handleOpen(event));
        viewer.getControl().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                CView.this.handleKeyPressed(e);
            }

            public void keyReleased(KeyEvent e) {
                CView.this.handleKeyReleased(e);
            }
        });
    }

    public void createPartControl(Composite parent) {
        this.viewer = this.createViewer(parent);
        this.viewer.setUseHashlookup(true);
        this.viewer.setComparer(new CViewElementComparer());
        this.initContentProvider(this.viewer);
        this.initLabelProvider(this.viewer);
        CUIPlugin.getDefault().getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
        this.initFilters(this.viewer);
        this.initWorkingSetFilter();
        this.initListeners(this.viewer);
        this.initCElementSorter();
        this.initFrameList();
        this.initDragAndDrop();
        this.updateTitle();
        this.viewer.setInput(CoreModel.getDefault().getCModel());
        this.initContextMenu();
        IWorkingSetManager wsmanager = this.getViewSite().getWorkbenchWindow().getWorkbench().getWorkingSetManager();
        wsmanager.addPropertyChangeListener(this.workingSetListener);
        this.getSite().setSelectionProvider((ISelectionProvider)this.viewer);
        this.getSite().getPage().addPartListener(this.partListener);
        this.makeActions();
        this.getActionGroup().fillActionBars(this.getViewSite().getActionBars());
        this.updateActionBars((IStructuredSelection)this.viewer.getSelection());
        if (this.memento != null) {
            this.getActionGroup().restoreFilterAndSorterState(this.memento);
        } else {
            this.initFilterFromPreferences();
        }
        if (this.memento != null) {
            this.restoreState(this.memento);
        }
        this.memento = null;
        IContextService ctxService = (IContextService)this.getSite().getService(IContextService.class);
        if (ctxService != null) {
            this.fContextActivation = ctxService.activateContext("org.eclipse.cdt.ui.cViewScope");
        }
    }

    protected ProblemTreeViewer createViewer(Composite parent) {
        return new RemoteTreeViewer(parent, 770);
    }

    protected IContentProvider createContentProvider() {
        boolean showCUChildren = PreferenceConstants.getPreferenceStore().getBoolean("org.eclipse.cdt.ui.editor.CUChildren");
        boolean groupIncludes = PreferenceConstants.getPreferenceStore().getBoolean("org.eclipse.cdt.ui.cview.groupincludes");
        boolean groupMacros = PreferenceConstants.getPreferenceStore().getBoolean("org.eclipse.cdt.ui.cview.groupmacros");
        CViewContentProvider provider = new CViewContentProvider(this.viewer, this.getSite(), showCUChildren, true);
        provider.setIncludesGrouping(groupIncludes);
        provider.setMacroGrouping(groupMacros);
        return provider;
    }

    protected CUILabelProvider createLabelProvider() {
        return new CViewLabelProvider(1073742345L, 3);
    }

    public void dispose() {
        IContextService ctxService;
        if (this.fContextActivation != null && (ctxService = (IContextService)this.getSite().getService(IContextService.class)) != null) {
            ctxService.deactivateContext(this.fContextActivation);
        }
        this.getSite().getPage().removePartListener(this.partListener);
        CUIPlugin.getDefault().getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this);
        if (this.getActionGroup() != null) {
            this.getActionGroup().dispose();
        }
        IWorkingSetManager wsmanager = this.getViewSite().getWorkbenchWindow().getWorkbench().getWorkingSetManager();
        wsmanager.removePropertyChangeListener(this.workingSetListener);
        Control control = this.viewer.getControl();
        if (this.dragDetectListener != null && control != null && !control.isDisposed()) {
            control.removeListener(29, this.dragDetectListener);
        }
        super.dispose();
    }

    void editorActivated(IEditorPart editor) {
        if (!CPluginPreferencePage.isLinkToEditor()) {
            return;
        }
        IEditorInput input = editor.getEditorInput();
        Object linkElement = null;
        if (input instanceof IFileEditorInput) {
            IFileEditorInput fileInput;
            IFile file;
            CoreModel factory = CoreModel.getDefault();
            ICElement celement = factory.create(file = (fileInput = (IFileEditorInput)input).getFile());
            linkElement = celement != null ? celement : file;
        } else if (input instanceof ITranslationUnitEditorInput) {
            ITranslationUnitEditorInput tuInput = (ITranslationUnitEditorInput)input;
            linkElement = tuInput.getTranslationUnit();
        }
        if (linkElement != null) {
            StructuredSelection newSelection = new StructuredSelection(linkElement);
            if (!this.viewer.getSelection().equals(newSelection)) {
                this.viewer.setSelection((ISelection)newSelection);
            }
        }
    }

    public IWorkingSet getWorkingSet() {
        return this.workingSetFilter.getWorkingSet();
    }

    public CElementSorter getSorter() {
        return (CElementSorter)this.getViewer().getSorter();
    }

    public TreeViewer getViewer() {
        return this.viewer;
    }

    public FrameList getFrameList() {
        return this.frameList;
    }

    void makeActions() {
        this.setActionGroup(new MainActionGroup(this));
    }

    protected void fillContextMenu(IMenuManager menu) {
        IStructuredSelection selection = (IStructuredSelection)this.getViewer().getSelection();
        CViewActionGroup actionGroup = this.getActionGroup();
        if (actionGroup != null) {
            actionGroup.setContext(new ActionContext((ISelection)selection));
            actionGroup.fillContextMenu(menu);
            actionGroup.setContext(null);
        }
    }

    String getToolTipText(Object element) {
        if (element instanceof IResource) {
            IPath path = ((IResource)element).getFullPath();
            if (path.isRoot()) {
                return "CVIEW";
            }
            return path.makeRelative().toString();
        }
        return ((ILabelProvider)this.viewer.getLabelProvider()).getText(element);
    }

    String getStatusLineMessage(IStructuredSelection selection) {
        if (selection.size() == 1) {
            Object o = selection.getFirstElement();
            if (o instanceof IResource) {
                return ((IResource)o).getFullPath().makeRelative().toString();
            }
            if (o instanceof ICElement) {
                ICElement celement = (ICElement)o;
                IResource res = (IResource)celement.getAdapter(IResource.class);
                if (res != null) {
                    return res.getFullPath().toString();
                }
                if (celement.getElementType() == 30) {
                    if (celement instanceof IBinaryContainer) {
                        ICProject cproj = celement.getCProject();
                        if (cproj != null) {
                            return String.valueOf(cproj.getPath()) + CViewMessages.CView_binaries;
                        }
                    } else if (celement instanceof IArchiveContainer) {
                        ICProject cproj = celement.getCProject();
                        if (cproj != null) {
                            return String.valueOf(cproj.getPath()) + CViewMessages.CView_archives;
                        }
                    } else if (celement instanceof IBinaryModule) {
                        IBinary bin = ((IBinaryModule)celement).getBinary();
                        return String.valueOf(bin.getPath()) + ":" + celement.getElementName();
                    }
                } else if (celement.getElementType() > 60) {
                    return celement.getPath().toString() + " - [" + celement.getElementName() + "]";
                }
                return celement.getElementName();
            }
            if (o instanceof IWorkbenchAdapter) {
                IWorkbenchAdapter wAdapter = (IWorkbenchAdapter)o;
                return wAdapter.getLabel(o);
            }
            return "ItemSelected";
        }
        if (selection.size() > 1) {
            return NLS.bind((String)CViewMessages.CView_statusLine, (Object[])new String[]{Integer.toString(selection.size())});
        }
        return "";
    }

    protected void updateActionBars(IStructuredSelection selection) {
        CViewActionGroup group = this.getActionGroup();
        if (group != null) {
            group.setContext(new ActionContext((ISelection)selection));
            group.updateActionBars();
        }
    }

    void updateTitle() {
        Object input = this.getViewer().getInput();
        String viewName = this.getConfigurationElement().getAttribute("name");
        if (input == null || input instanceof ICModel) {
            this.setPartName(viewName);
            this.setTitleToolTip("");
        } else {
            ILabelProvider labelProvider = (ILabelProvider)this.getViewer().getLabelProvider();
            String inputText = labelProvider.getText(input);
            this.setPartName(inputText);
            this.setTitleToolTip(this.getToolTipText(input));
        }
    }

    void updateStatusLine(IStructuredSelection selection) {
        String msg = this.getStatusLineMessage(selection);
        this.getViewSite().getActionBars().getStatusLineManager().setMessage(msg);
    }

    public void setWorkingSet(IWorkingSet workingSet) {
        TreeViewer treeViewer = this.getViewer();
        Object[] expanded = treeViewer.getExpandedElements();
        ISelection selection = treeViewer.getSelection();
        this.workingSetFilter.setWorkingSet(workingSet);
        this.updateTitle();
        treeViewer.refresh();
        treeViewer.setExpandedElements(expanded);
        if (!selection.isEmpty() && selection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            treeViewer.reveal(structuredSelection.getFirstElement());
        }
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (this.viewer == null) {
            return;
        }
        boolean refreshViewer = false;
        String property = event.getProperty();
        if (property.equals("org.eclipse.cdt.ui.editor.CUChildren")) {
            boolean showCUChildren = PreferenceConstants.getPreferenceStore().getBoolean("org.eclipse.cdt.ui.editor.CUChildren");
            IContentProvider provider = this.viewer.getContentProvider();
            if (provider instanceof CElementContentProvider) {
                ((CElementContentProvider)provider).setProvideMembers(showCUChildren);
            }
            refreshViewer = true;
        } else if (property.equals("org.eclipse.cdt.ui.editor.linkToEditor")) {
            CViewActionGroup group = this.getActionGroup();
            if (group instanceof MainActionGroup) {
                boolean enable = this.isLinkingEnabled();
                ((MainActionGroup)group).toggleLinkingAction.setChecked(enable);
            }
        } else if (property.equals("org.eclipse.cdt.ui.cview.groupincludes")) {
            boolean groupIncludes = PreferenceConstants.getPreferenceStore().getBoolean("org.eclipse.cdt.ui.cview.groupincludes");
            IContentProvider provider = this.viewer.getContentProvider();
            if (provider instanceof CElementContentProvider) {
                ((CElementContentProvider)provider).setIncludesGrouping(groupIncludes);
            }
            refreshViewer = true;
        } else if (property.equals("org.eclipse.cdt.ui.cview.groupmacros")) {
            boolean groupMacros = PreferenceConstants.getPreferenceStore().getBoolean("org.eclipse.cdt.ui.cview.groupmacros");
            IContentProvider provider = this.viewer.getContentProvider();
            if (provider instanceof CElementContentProvider) {
                ((CElementContentProvider)provider).setMacroGrouping(groupMacros);
            }
            refreshViewer = true;
        }
        if (refreshViewer) {
            this.viewer.refresh();
        }
    }

    public boolean isLinkingEnabled() {
        return CPluginPreferencePage.isLinkToEditor();
    }

    public void setLinkingEnabled(boolean enable) {
        IEditorPart editor;
        CPluginPreferencePage.setLinkingEnabled(enable);
        if (enable && (editor = this.getSite().getPage().getActiveEditor()) != null) {
            this.editorActivated(editor);
        }
    }

    void linkToEditor(IStructuredSelection selection) {
        Object obj;
        IEditorPart part;
        if (!this.isActivePart()) {
            return;
        }
        if (selection.size() == 1 && (part = EditorUtility.isOpenInEditor(obj = selection.getFirstElement())) != null) {
            IWorkbenchPage page = this.getSite().getPage();
            page.bringToTop((IWorkbenchPart)part);
            if (obj instanceof ISourceReference && obj instanceof ICElement && !(obj instanceof ITranslationUnit)) {
                EditorUtility.revealInEditor(part, (ICElement)obj);
            }
        }
    }

    private boolean isActivePart() {
        return this == this.getSite().getPage().getActivePart();
    }

    public Object getViewPartInput() {
        if (this.viewer != null) {
            return this.viewer.getInput();
        }
        return null;
    }

    void restoreState(IMemento memento) {
        int position;
        String posStr2;
        Tree tree;
        ScrollBar bar;
        Path path;
        ICElement element;
        String p;
        IMemento element2;
        int n;
        int n2;
        IMemento[] iMementoArray;
        IMemento[] elementMem;
        CoreModel factory = CoreModel.getDefault();
        this.getActionGroup().restoreFilterAndSorterState(memento);
        IMemento childMem = memento.getChild(TAG_EXPANDED);
        if (childMem != null) {
            ArrayList<ICElement> elements = new ArrayList<ICElement>();
            iMementoArray = elementMem = childMem.getChildren(TAG_ELEMENT);
            n2 = elementMem.length;
            n = 0;
            while (n < n2) {
                element2 = iMementoArray[n];
                p = element2.getString(TAG_PATH);
                if (p != null && (element = factory.create((IPath)(path = new Path(p)))) != null) {
                    elements.add(element);
                }
                ++n;
            }
            this.viewer.setExpandedElements(elements.toArray());
        }
        if ((childMem = memento.getChild(TAG_SELECTION)) != null) {
            ArrayList<ICElement> list = new ArrayList<ICElement>();
            iMementoArray = elementMem = childMem.getChildren(TAG_ELEMENT);
            n2 = elementMem.length;
            n = 0;
            while (n < n2) {
                element2 = iMementoArray[n];
                p = element2.getString(TAG_PATH);
                if (p != null && (element = factory.create((IPath)(path = new Path(p)))) != null) {
                    list.add(element);
                }
                ++n;
            }
            this.viewer.setSelection((ISelection)new StructuredSelection(list));
        }
        if ((bar = (tree = this.viewer.getTree()).getVerticalBar()) != null) {
            try {
                posStr2 = memento.getString(TAG_VERTICAL_POSITION);
                position = Integer.parseInt(posStr2);
                bar.setSelection(position);
            }
            catch (NumberFormatException posStr2) {
                // empty catch block
            }
        }
        if ((bar = tree.getHorizontalBar()) != null) {
            try {
                posStr2 = memento.getString(TAG_HORIZONTAL_POSITION);
                position = Integer.parseInt(posStr2);
                bar.setSelection(position);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    public void saveState(IMemento memento) {
        String wsname;
        ScrollBar bar;
        Object[] elements;
        int n;
        if (this.viewer == null) {
            if (this.memento != null) {
                memento.putMemento(this.memento);
            }
            return;
        }
        Tree tree = this.viewer.getTree();
        Object[] expandedElements = this.viewer.getExpandedElements();
        if (expandedElements.length > 0) {
            IMemento expandedMem = memento.createChild(TAG_EXPANDED);
            Object[] objectArray = expandedElements;
            n = expandedElements.length;
            int n2 = 0;
            while (n2 < n) {
                Object expandedElement = objectArray[n2];
                Object o = expandedElement;
                if (!(!(o instanceof IParent) || o instanceof IArchiveContainer || o instanceof IBinaryContainer || o instanceof IBinary || o instanceof IArchive)) {
                    IMemento elementMem = expandedMem.createChild(TAG_ELEMENT);
                    ICElement e = (ICElement)o;
                    IResource res = e.getResource();
                    if (res != null && res.getLocation() != null) {
                        elementMem.putString(TAG_PATH, res.getLocation().toOSString());
                    }
                }
                ++n2;
            }
        }
        if ((elements = ((IStructuredSelection)this.viewer.getSelection()).toArray()).length > 0) {
            IMemento selectionMem = memento.createChild(TAG_SELECTION);
            Object[] objectArray = elements;
            int n3 = elements.length;
            n = 0;
            while (n < n3) {
                ICElement e;
                IResource r;
                Object element = objectArray[n];
                if (element instanceof ICElement && (r = (e = (ICElement)element).getResource()) != null && r.getLocation() != null) {
                    IMemento elementMem = selectionMem.createChild(TAG_ELEMENT);
                    elementMem.putString(TAG_PATH, r.getLocation().toString());
                }
                ++n;
            }
        }
        int position = (bar = tree.getVerticalBar()) != null ? bar.getSelection() : 0;
        memento.putString(TAG_VERTICAL_POSITION, String.valueOf(position));
        bar = tree.getHorizontalBar();
        position = bar != null ? bar.getSelection() : 0;
        memento.putString(TAG_HORIZONTAL_POSITION, String.valueOf(position));
        this.getActionGroup().saveFilterAndSorterState(memento);
        if (this.workingSetFilter.getWorkingSet() != null && (wsname = this.workingSetFilter.getWorkingSet().getName()) != null) {
            memento.putString(TAG_WORKINGSET, wsname);
        }
    }

    public boolean show(ShowInContext context) {
        IResource res;
        ISelection selection = context.getSelection();
        if (selection != null && !selection.isEmpty() && selection instanceof IStructuredSelection) {
            this.selectReveal(selection);
            return true;
        }
        IEditorInput input = (IEditorInput)context.getInput();
        if (input != null && (res = (IResource)input.getAdapter(IResource.class)) != null) {
            this.selectReveal((ISelection)new StructuredSelection((Object)res));
            return true;
        }
        return false;
    }

    protected IShowInSource getShowInSource() {
        return () -> new ShowInContext(this.getViewer().getInput(), this.getViewer().getSelection());
    }

    public String[] getShowInTargetIds() {
        return new String[]{"org.eclipse.ui.navigator.ProjectExplorer"};
    }
}

