/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.search;

import java.net.URI;
import org.eclipse.cdt.core.index.IIndexFileLocation;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class CSearchElement
implements IAdaptable {
    private final IIndexFileLocation location;

    public CSearchElement(IIndexFileLocation loc) {
        this.location = loc;
    }

    public int hashCode() {
        return this.location.hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof CSearchElement)) {
            return false;
        }
        CSearchElement other = (CSearchElement)obj;
        return this.location.equals(other.location);
    }

    final IIndexFileLocation getLocation() {
        return this.location;
    }

    public Object getAdapter(Class adapterType) {
        if (adapterType.isAssignableFrom(IFile.class)) {
            String fullPath = this.location.getFullPath();
            if (fullPath != null) {
                return ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(fullPath));
            }
        } else {
            if (adapterType.isAssignableFrom(IFileStore.class)) {
                try {
                    return EFS.getStore((URI)this.location.getURI());
                }
                catch (CoreException e) {
                    return null;
                }
            }
            if (adapterType.isAssignableFrom(IIndexFileLocation.class)) {
                return this.location;
            }
        }
        return null;
    }
}

