import os

import gi

import stillCenter.constants as constants

gi.require_version("Gtk", "4.0")
gi.require_version("Adw", "1")
from gi.repository import Gtk, Adw


@Gtk.Template(filename=os.path.join(constants.UI_DIR, "ErrorPage.ui"))
class ErrorPage(Adw.NavigationPage):
    __gtype_name__ = "ErrorPage"
    error_status: Adw.StatusPage = Gtk.Template.Child()
    stillCenter = None

    def __init__(self, stillCenter, error_title, error_description):
        super().__init__()
        self.stillCenter = stillCenter
        self.error_status.set_title(error_title)
        self.error_status.set_description(error_description)

    def set_icon(self, icon_name):
        self.error_status.set_icon_name(icon_name)

    def push(self):
        self.stillCenter.main_view.push(self)

    def pop(self):
        self.stillCenter.main_view.pop()
