# SWAI Generator

A CLI tool to generate `.swai` files from website manifests (PWA manifest.json files).

## Installation

```bash
cd tools/swai-generator
npm install
```

### Global Installation (optional)

```bash
npm install -g .
```

## Usage

```bash
# Basic usage - generates a .swai file from a URL
node index.js https://example.com

# Or if installed globally
swai-generator https://example.com
```

### Options

| Option | Description |
|--------|-------------|
| `-o, --output <path>` | Output file path (default: `./<app_id>.swai`) |
| `-n, --name <name>` | Override app name from manifest |
| `-i, --id <id>` | Override app ID (default: generated from URL) |
| `--no-dynamic-titlebar` | Disable dynamic titlebar colors |
| `--use-manifest` | Enable `use_manifest` flag in generated file |
| `-v, --verbose` | Verbose output |
| `-h, --help` | Show help |

### Examples

```bash
# Generate .swai for Google Docs
node index.js https://docs.google.com

# Generate with custom output path
node index.js https://app.slack.com -o ~/swai-apps/slack.swai

# Generate with custom app name and ID
node index.js https://example.com -n "My App" -i "com.example.myapp"

# Generate with use_manifest enabled (will fetch manifest at runtime too)
node index.js https://example.com --use-manifest

# Verbose output to see what's being detected
node index.js https://example.com -v
```

## What it extracts

The tool fetches the website and its manifest.json to extract:

- **App Name**: From manifest `name` or `short_name`, falls back to page title
- **App ID**: Generated from hostname (e.g., `docs.google.com` → `com.google.docs`)
- **Main URL**: From manifest `start_url` or the provided URL
- **Allowed URLs**: 
  - Base origin with wildcard
  - Manifest `scope`
  - Manifest `scope_extensions`
- **Categories**: From manifest `categories`
- **Comment/Description**: From manifest `description`
- **Icon URL**: Best icon from manifest `icons`

## Requirements

- Node.js 18+ (uses native fetch)

