require_relative 'spec_helper'

TicRecommendedCurrentCodeDump = <<END
T825
0,0
1,32
2,64
3,96
4,128
5,160
6,192
7,224
8,256
9,288
10,320
11,352
12,384
13,416
14,448
15,480
16,512
17,544
18,576
19,608
20,640
21,672
22,704
23,736
24,768
25,800
26,832
27,864
28,896
29,928
30,960
31,992
32,1024
34,1088
36,1152
38,1216
40,1280
42,1344
44,1408
46,1472
48,1536
50,1600
52,1664
54,1728
56,1792
58,1856
60,1920
62,1984
64,2048
68,2176
72,2304
76,2432
80,2560
84,2688
88,2816
92,2944
96,3072
100,3200
104,3328
108,3456
112,3584
116,3712
120,3840
124,3968
T834
0,0
1,32
2,64
3,96
4,128
5,160
6,192
7,224
8,256
9,288
10,320
11,352
12,384
13,416
14,448
15,480
16,512
17,544
18,576
19,608
20,640
21,672
22,704
23,736
24,768
25,800
26,832
27,864
28,896
29,928
30,960
31,992
32,1024
34,1088
36,1152
38,1216
40,1280
42,1344
44,1408
46,1472
48,1536
50,1600
52,1664
54,1728
56,1792
58,1856
60,1920
62,1984
64,2048
68,2176
72,2304
76,2432
80,2560
84,2688
88,2816
92,2944
96,3072
100,3200
104,3328
108,3456
T500
0,0
1,1
2,174
3,343
4,495
5,634
6,762
7,880
8,990
9,1092
10,1189
11,1281
12,1368
13,1452
14,1532
15,1611
16,1687
17,1762
18,1835
19,1909
20,1982
21,2056
22,2131
23,2207
24,2285
25,2366
26,2451
27,2540
28,2634
29,2734
30,2843
31,2962
32,3093
N825
0,0
1,32
2,64
3,96
4,128
5,160
6,192
7,224
8,256
9,288
10,320
11,352
12,384
13,416
14,448
15,480
16,512
17,544
18,576
19,608
20,640
21,672
22,704
23,736
24,768
25,800
26,832
27,864
28,896
29,928
30,960
31,992
32,1024
34,1088
36,1152
38,1216
40,1280
42,1344
44,1408
46,1472
48,1536
50,1600
52,1664
54,1728
56,1792
58,1856
60,1920
62,1984
64,2048
68,2176
72,2304
76,2432
80,2560
84,2688
88,2816
92,2944
96,3072
100,3200
104,3328
108,3456
112,3584
116,3712
120,3840
124,3968
T249
0,0
1,40
2,80
3,120
4,160
5,200
6,240
7,280
8,320
9,360
10,400
11,440
12,480
13,520
14,560
15,600
16,640
17,680
18,720
19,760
20,800
21,840
22,880
23,920
24,960
25,1000
26,1040
27,1080
28,1120
29,1160
30,1200
31,1240
32,1280
34,1360
36,1440
38,1520
40,1600
42,1680
44,1760
46,1840
48,1920
50,2000
52,2080
54,2160
56,2240
58,2320
60,2400
62,2480
64,2560
68,2720
72,2880
76,3040
80,3200
84,3360
88,3520
92,3680
96,3840
100,4000
104,4160
108,4320
112,4480
36v4
0,0
1,72
2,143
3,215
4,286
5,358
6,430
7,501
8,573
9,645
10,716
11,788
12,859
13,931
14,1003
15,1074
16,1146
17,1217
18,1289
19,1361
20,1432
21,1504
22,1576
23,1647
24,1719
25,1790
26,1862
27,1934
28,2005
29,2077
30,2148
31,2220
32,2292
33,2363
34,2435
35,2507
36,2578
37,2650
38,2721
39,2793
40,2865
41,2936
42,3008
43,3079
44,3151
45,3223
46,3294
47,3366
48,3438
49,3509
50,3581
51,3652
52,3724
53,3796
54,3867
55,3939
56,4010
57,4082
58,4154
59,4225
60,4297
61,4368
62,4440
63,4512
64,4583
65,4655
66,4727
67,4798
68,4870
69,4941
70,5013
71,5085
72,5156
73,5228
74,5299
75,5371
76,5443
77,5514
78,5586
79,5658
80,5729
81,5801
82,5872
83,5944
84,6016
85,6087
86,6159
87,6230
88,6302
89,6374
90,6445
91,6517
92,6589
93,6660
94,6732
95,6803
96,6875
97,6947
98,7018
99,7090
100,7161
101,7233
102,7305
103,7376
104,7448
105,7520
106,7591
107,7663
108,7734
109,7806
110,7878
111,7949
112,8021
113,8092
114,8164
115,8236
116,8307
117,8379
118,8451
119,8522
120,8594
121,8665
122,8737
123,8809
124,8880
125,8952
126,9023
127,9095
END

describe 'current limit code' do
  it 'works' do
    # The C++ side tests a lot of things about the current limit.  We run it to
    # make sure there are no errors, that the set of recommended codes hasn't
    # changed by accident, and we also check to make sure it up-to-date and is
    # actually testing every product.
    stdout, stderr, code = run_ticcmd('--test 3')
    expect(stderr).to eq ''
    expect(stdout).to eq TicRecommendedCurrentCodeDump
    expect(code).to eq 0

    TicProductSymbols.each do |sym|
      expect(stdout).to include(sym.to_s)
    end
  end
end
